package com.daas.nros.connector.server.config.burgeon;

import com.alibaba.nacos.client.identify.Base64;
import com.daas.nros.connector.client.util.DateUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

@Component
public class IposConfig {

    @Value("${connector.jh.appId}")
    public String initAppId;

    public static String appId;

    @Value("${connector.jh.appSecret}")
    public  String initAppSecret;
    public static String appSecret;

    @Value("${connector.jh.version}")
    public  String initVersion;
    public static String version;

    @Value("${connector.jh.urlPrefix}")
    public  String initUrl;
    public static String url;

    @PostConstruct
    private void init() {
        appId = initAppId;
        appSecret = initAppSecret;
        version = initVersion;
        url = initUrl;
    }

    public static Map signToRequest(String method) {
        String timestamp = DateUtil.getCurrentStateTime();
        Map map = new HashMap<>();
        map.put("appId", appId);
        map.put("method", method);
        map.put("timestamp", timestamp);
        map.put("version", version);
        StringBuffer param = new StringBuffer();
        try {
            param.append("appId=" + new String(Base64.encodeBase64(appId.getBytes(StandardCharsets.UTF_8))));
            param.append("&appSecret=" + new String(Base64.encodeBase64(appSecret.getBytes(StandardCharsets.UTF_8))));
            param.append("&version=" + new String(Base64.encodeBase64(version.getBytes(StandardCharsets.UTF_8))));
            param.append("&method=" + new String(Base64.encodeBase64(method.getBytes(StandardCharsets.UTF_8))));
            param.append("&timestamp=" + new String(Base64.encodeBase64(timestamp.getBytes(StandardCharsets.UTF_8))));
            String query = param.toString();
            map.put("sign",MD5(query).toUpperCase());
            return map;
        } catch (Exception e) {
            return null;
        }
    }

    public static String MD5(String str) {
        String r = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte b[] = md.digest();
            int i;
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0)
                    i += 256;
                if (i < 16)
                    buf.append("0");
                buf.append(Integer.toHexString(i));
            }
            r = buf.toString();
        } catch (Exception e) {

        }
        return r;
    }
}