/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.client.util;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static int CONNECT_TIME_OUT = 30000;

    public static String doPost(String url, String postData) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-type", "application/json;charset=utf-8");
        return HttpClientUtil.dopost(url, postData, map);
    }

    public static String dopost(String url, String postData, Map<String, String> headers) {
        HttpPost post = new HttpPost();
        CloseableHttpResponse response = null;
        try {
            post.setURI(new URI(url));
            if (StringUtils.isNotBlank((CharSequence)postData)) {
                post.setEntity((HttpEntity)new StringEntity(postData, StandardCharsets.UTF_8));
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClientUtil.builderByUrl(url, CONNECT_TIME_OUT);
            response = httpClient.execute((HttpUriRequest)post);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (SocketTimeoutException e) {
            throw new BizException(SysResponseEnum.NETWORK_ERROR.getCode(), "\u54cd\u5e94\u8d85\u65f6");
        }
        catch (ConnectTimeoutException e) {
            throw new BizException(SysResponseEnum.NETWORK_ERROR.getCode(), "\u54cd\u5e94\u8d85\u65f6");
        }
        catch (Exception e) {
            log.info("post error:{}", (Throwable)e);
            throw new RuntimeException("got an error from HTTP for url:" + url, e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            post.releaseConnection();
        }
    }

    public static String dopostTimeOut(String url, String postData, Map<String, String> headers) {
        HttpPost post = new HttpPost();
        CloseableHttpResponse response = null;
        try {
            post.setURI(new URI(url));
            if (StringUtils.isNotBlank((CharSequence)postData)) {
                post.setEntity((HttpEntity)new StringEntity(postData, "UTF-8"));
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClientUtil.builderByUrl(url, 100);
            response = httpClient.execute((HttpUriRequest)post);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.info("post error:{}", (Throwable)e);
            throw new RuntimeException("got an error from HTTP for url:" + url + "   " + e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            post.releaseConnection();
        }
    }

    private static CloseableHttpClient builderByUrl(String url, int connectTimeOut) throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeOut).setConnectionRequestTimeout(connectTimeOut).setSocketTimeout(connectTimeOut).build();
        log.info("url:{}", (Object)url);
        if (StringUtils.isNotBlank((CharSequence)url) && url.contains("https://dalaran-runtime-qas.mall-qas.vgrassstudio.com:214432")) {
            log.info("\u5ffd\u7565ssl\u8bc1\u4e66");
            return HttpClientUtil.buildSSLCloseableHttpClient(requestConfig);
        }
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    private static CloseableHttpClient buildSSLCloseableHttpClient(RequestConfig requestConfig) throws Exception {
        TrustStrategy trustSelfSignedStrategy = (x509Certificates, s) -> true;
        HostnameVerifier hv = (urlHostName, session) -> {
            log.info("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
            return true;
        };
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustSelfSignedStrategy).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, hv);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(requestConfig).build();
    }

    public static String doget(String url, Map<String, String> headers) {
        HttpGet get = new HttpGet();
        HttpResponse response = null;
        try {
            get.setURI(new URI(url));
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            response = httpClient.execute((HttpUriRequest)get);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("got an error from HTTP for url:" + url, e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            get.releaseConnection();
        }
    }

    public static void main(String[] args) {
    }

    private void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

