package com.daas.nros.connector.client.weimob.model.req;


import lombok.Data;

/**
 * 会员等级变更
 */
@Data
public class MemberLevelChangeReq {

    /**
     * 用户 ID，是微盟用户身份的唯一标识。可通过 bos/user/search 接口获取 wid。
     * 是否必填：是
     */
    private Long wid;

    /**
     * 延期类型，更新类型为会员卡延期时必填。支持的类型包括：0-根据卡模板设置的过期参数延期；1-自定义，过期时间必填
     * 是否必填：否
     */
    private Long delayType;

    /**
     * 新卡号
     * 是否必填：否
     */
    private String newCustomCardNo;

    /**
     * 更改原因
     * 是否必填：是
     */
    private String reason;

    /**
     * 操作者名称
     * 是否必填：是
     */
    private String operatorName;

    /**
     * 旧号码
     * 是否必填：否
     */
    private String oldCustomCardNo;

    /**
     * 更新类型。支持的类型包括：1-更新卡号；2-会员卡延期；3-调整等级。
     * 是否必填：是
     */
    private Integer updateType;

    /**
     * 会员等级 ID。可以通过 weimob_crm/membercard/getList 获取该 ID。
     * 是否必填：否
     */
    private Long levelId;

    /**
     * 操作人 ID
     * 是否必填：是
     */
    private Long operatorWId;

    /**
     * 过期时间，延期类型为自定义延期时必填。
     * 是否必填：否
     */
    private Long expireTime;

    /**
     * 会员方案 ID。可以通过 weimob_crm/membercard/getList 获取该 ID。
     * 是否必填：是
     * 默认值：
     */
    private Long membershipPlanId = 800825244L;

    /**
     * 成长值变更渠道，调整成长值等级时必填。支持的类型包括：972-充值；971-消费；970-评论；969-分享店铺；968-访问店铺；967-补充信息；965-关注公众号。
     * 是否必填：否
     */
    private Integer channelType;

    /**
     * 成长值变更渠道 ID，调整成长值等级时必填。
     * 是否必填：否
     */
    private Integer channelId;
}
