package com.daas.nros.connector.client.weimob.model.req;

import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.model.req.param.CouponDefinitionParam;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * CRM -> WM
 * 新建优惠卷
 */
@Data
public class CouponCreateReq {

    /**
     * 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
     * 是否必填：否
     */
    private Integer vid;

    /**
     * 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
     * 是否必填：否
     */
    private Integer vidType;

    /**
     * 优惠卷基础信息
     * 是否必填：是
     */
    private CouponBaseInfo baseInfo;

    /**
     * 优惠卷设置
     * 是否必填：是
     */
    private CouponSetting setting;

    /**
     * 优惠卷发放规则
     * 是否必填：是
     */
    private CouponSendRule sendRule;

    /**
     * 优惠卷使用规则
     * 是否必填：是
     */
    private CouponUseRule useRule;

    /**
     * 优惠卷其他设置
     * 是否必填：是
     */
    private CouponOtherSetting otherSetting;

    /**
     * 优惠卷创建信息
     * 是否必填：是
     */
    private CouponCreateInfo createInfo;

    /**
     * 构建 卷基础信息
     */
    public void buildCouponBaseInfo(CouponDefinitionParam param) {
        this.baseInfo = new CouponBaseInfo();
        this.baseInfo.setName(param.getCouponName());
        // 基础模板 ID，目前一次只能传一个基础模板。
        this.baseInfo.setBasicCouponTemplateIdList(param.getBasicCouponTemplateIdList());
    }


    /**
     * 构建 优惠卷设置
     *
     * @param param
     */
    public void buildCouponSetting(CouponDefinitionParam param) {
        // 优惠券库存, 固定值：int的最大值
        int stock = 9999999;
        this.setting = new CouponSetting();
        this.setting.setStock(stock);
    }

    /**
     * 构建 优惠卷发放规则
     *
     * @param param
     */
    public void buildCouponSendRule(CouponDefinitionParam param) {
        // 发放时间类型：1-无限制；2-固定时间。  固定值 1
        int sendTimeType = 1;
        // 是否付费券。true-是；false-不是。非付费券时，发券渠道必传。默认false。  固定值 false
        boolean isPayment = false;
        // 是否开启商家发券渠道, 固定值 true
        boolean merchantPublish = true;
        // 是否开启客户直接领取发券。是true；否false。固定值 false
        boolean customerDirectReceive = false;
        // 是否适用全部人群。true-适用；false-不适用. 固定值 true
        boolean isAcceptAllCrowd = true;
        // 用户限领优惠券张数, 固定值 100
        int userTakeLimit = 100;
        // 是否开启客户列表发券(商家发券下级)。true-开启；false-不开启。
        boolean customerListPublish = true;
        // 是否限制转增次数。true-限制；false-不限制。默认不限制, 固定值 false
        boolean hasGiftLimit = false;
        // 是否开启客服发券(商家发券下级)。true-开启；false-不开启。固定值 true
        boolean servicePublish = true;
        // 活动发券。true-发；false-不发。固定值 false
        boolean activityPublish = true;
        // 是否开启导购发券(商家发券下级)。true-开启；false-不开启。固定值 false
        boolean shoppingPublish = false;
        // 是否开启企微助手渠道。true-开启；false-不开启。固定值true
        boolean enterpriseAssistant = true;
        this.sendRule = new CouponSendRule();
        this.sendRule.setSendTimeType(sendTimeType);
        this.sendRule.setIsPayment(isPayment);
        this.sendRule.setMerchantPublish(merchantPublish);
        this.sendRule.setCustomerDirectReceive(customerDirectReceive);
        this.sendRule.setIsAcceptAllCrowd(isAcceptAllCrowd);
        this.sendRule.setUserTakeLimit(userTakeLimit);
        this.sendRule.setCustomerListPublish(customerListPublish);
        this.sendRule.setHasGiftLimit(hasGiftLimit);
        this.sendRule.setServicePublish(servicePublish);
        this.sendRule.setActivityPublish(activityPublish);
        this.sendRule.setShoppingPublish(shoppingPublish);
        this.sendRule.setEnterpriseAssistant(enterpriseAssistant);
        if (null != param.getIsTransfer() && param.getIsTransfer()) {
            this.sendRule.setCanGift(Boolean.TRUE);
        } else {
            this.sendRule.setCanGift(Boolean.FALSE);
        }

    }

    /**
     * 构建 优惠卷使用规则
     *
     * @param param
     */
    public void buildCouponUseRule(CouponDefinitionParam param) {
        // 是否是全部时段可用。true-全部时段可用；false-非全部时段可用。 固定值 true
        boolean isAllTimeUse = true;
        // 下单可同时使用抵扣:1-积分；2-余额；3-礼品卡。不使用抵扣则传空。固定值传空
        List<Integer> orderDeductList = new ArrayList<>();
        this.useRule = new CouponUseRule();
        this.useRule.setIsAllTimeUse(isAllTimeUse);
        this.useRule.setOrderDeductList(orderDeductList);
        // 构建 券使用有效期
        this.useRule.buildCouponUseValidDate(param);
        // 解析入参的最大购买件数
        int maxGoodsNumber = getMaxGoodsNumber(param.getGoodsCondition());
        if (maxGoodsNumber > 0) {
            // 开启满件门槛：true
            this.useRule.setCanGoodsNumber(Boolean.TRUE);
            // 最小购买件数限制，默认值为0
            this.useRule.setMinGoodsNumber(0);
            this.useRule.setMaxGoodsNumber(maxGoodsNumber);
        } else {
            // 开启满件门槛：false
            this.useRule.setCanGoodsNumber(Boolean.FALSE);
        }
    }

    /**
     * 解析入参的最大购买件数
     *
     * @param maxGoodsNumber
     * @return
     */
    private int getMaxGoodsNumber(String maxGoodsNumber) {
        int max = 0;
        if (StringUtils.isBlank(maxGoodsNumber)) {
            return max;
        }
        try {
            max = Integer.valueOf(maxGoodsNumber);
        } catch (Exception e) {
        }
        return max;
    }


    /**
     * 构建 优惠卷其他设置
     *
     * @param param
     */
    public void buildCouponOtherSetting(CouponDefinitionParam param) {
        // 是否开启库存提醒。true-开启；false-不开启。 固定值 false
        boolean isOpenMessage = false;
        this.otherSetting = new CouponOtherSetting();
        this.otherSetting.setExplain(param.getInfo());
        this.otherSetting.setIsOpenMessage(isOpenMessage);
    }

    /**
     * 构建 优惠卷创建信息
     *
     * @param param
     */
    public void buildCouponCreateInfo(CouponDefinitionParam param) {
        this.createInfo = new CouponCreateInfo();
        this.createInfo.setOperatorId(WmSystemConstant.WM_STSTEM_OPERATOR_ID);
    }

    /**
     * 卷基础信息
     */
    @Data
    public static class CouponBaseInfo {
        /**
         * 优惠券标题，不传同基础模板名称。
         * 是否必填：是
         */
        private String name;

        /**
         * 商户名称。不填时为空。
         * 是否必填：否
         */
        private String merchantName;

        /**
         * 基础模板 ID，目前一次只能传一个基础模板。
         * 是否必填：否
         */
        private List<Long> basicCouponTemplateIdList;
    }

    /**
     * 优惠卷设置
     */
    @Data
    public static class CouponSetting {

        /**
         * 优惠券库存
         * 是否必填：是
         */
        private Integer stock;
    }

    /**
     * 优惠卷发放规则
     */
    @Data
    public static class CouponSendRule {

        /**
         * 是否有限领。true-有限领；false-不限领。默认true。
         * 是否必填：否
         */
        private Boolean hasUserTakeLimit;

        /**
         * 发放时间类型：1-无限制；2-固定时间。
         * 是否必填：是
         */
        private Integer sendTimeType;

        /**
         * 发放开始时间，格式为时间戳，单位：毫秒。发放时间类型为固定时间时必填。
         * 是否必填：否
         */
        private Long sendStartDate;

        /**
         * 发放结束时间 格式为时间戳，单位：毫秒。发放时间类型为固定时间时必填。
         * 是否必填：否
         */
        private Long sendEndDate;

        /**
         * 是否付费券。true-是；false-不是。非付费券时，发券渠道必传。默认false。
         * 是否必填：是
         */
        private Boolean isPayment;

        /**
         * 是否开启客户直接领取发券。true-开启；false-不开启。
         * 是否必填：否
         */
        private Boolean customerDirectReceive;

        /**
         * 推荐领取开始时间。格式为时间戳，单位：毫秒。（客户直接领取渠道必填）
         * 是否必填：否
         */
        private Long recommendStartTime;

        /**
         * 推荐领取结束时间。格式为时间戳，单位：毫秒。（客户直接领取渠道必填）
         * 是否必填：否
         */
        private Long recommendEndTime;

        /**
         * 是活动发券。true-发；false-不发。
         * 是否必填：否
         */
        private Boolean activityPublish;

        /**
         * 用户限领优惠券张数
         * 是否必填：否
         */
        private Integer userTakeLimit;

        /**
         * 适用人群消息
         * 是否必填：否
         */
        private CouponCrowd crowd;

        /**
         * 是否可以转赠。true-可以；false-不可以
         * 是否必填：否
         */
        private Boolean canGift;

        /**
         * 是否开启企微助手渠道。true-开启；false-不开启
         * 是否必填：否
         */
        private Boolean enterpriseAssistant;

        /**
         * 是否适用全部人群。true-适用；false-不适用。
         * 是否必填：是
         */
        private Boolean isAcceptAllCrowd;

        /**
         * 是否限制转增次数。true-限制；false-不限制。默认不限制
         * 是否必填：否
         */
        private Boolean hasGiftLimit;

        /**
         * 转增次数
         * 是否必填：否
         */
        private Integer giftCountLimit;

        /**
         * 是否开启商家发券渠道
         * 是否必填：否
         */
        private Boolean merchantPublish;

        /**
         * 是否开启导购发券(商家发券下级)。true-开启；false-不开启
         * 是否必填：否
         */
        private Boolean shoppingPublish;

        /**
         * 是否开启客户列表发券(商家发券下级)。true-开启；false-不开启。
         * 是否必填：否
         */
        private Boolean customerListPublish;

        /**
         * 是否开启客服发券(商家发券下级)。true-开启；false-不开启
         * 是否必填：否
         */
        private Boolean servicePublish;

        /**
         * （商家发券下）单店最多发放，0不限制，默认0。
         * 是否必填：否
         */
        private Integer storeLimitNum;

        /**
         * 是否可以分享领取。true-可以；false-不可以。
         * 是否必填：否
         */
        private Boolean canShare;

        /**
         * 是否允许下级投放。true-允许；false-不允许。
         * 是否必填：否
         */
        private Boolean canStoreLaunch;


    }

    /**
     * 优惠卷使用规则
     */
    @Data
    public static class CouponUseRule {

        /**
         * 券使用有效期
         * 是否必填：是
         */
        private CouponUseValidDate useValidDate;

        /**
         * 下单可同时使用抵扣:1-积分；2-余额；3-礼品卡。不使用抵扣则传空。
         * 是否必填：是
         */
        private List<Integer> orderDeductList;

        /**
         * 是否是全部时段可用。true-全部时段可用；false-非全部时段可用。
         * 是否必填：是
         */
        private Boolean isAllTimeUse;

        /**
         * 部分时段可核销
         * 是否必填：否
         * 示例
         * [{"timeSegment":[{"beginHour":0,"beginMinute":2,"endHour":4,"endMinute":5}],"weekDay":[1,3]}]
         */
        private List<CouponCycleUseRule> cycleUseRule;

        /**
         * 否开启满件门槛。true-开启；false-不开启。
         * 是否必填：是
         */
        private Boolean canGoodsNumber;

        /**
         * 开启满件门槛最低数量
         * 是否必填：否
         */
        private Integer minGoodsNumber;

        /**
         * 开启满件门槛最高数量
         */
        private Integer maxGoodsNumber;

        /**
         * 构建 券使用有效期
         * 描述：CRM 卷有效期分为三种
         * 1. 自定义开始和结束时间
         * 2. 领卷后几天内有效
         * 3. 领卷后几天后生效，有效期为几天
         * 微盟卷有效期分为三种
         * 1. 固定时间
         * 2. 动态时间
         * 3. 周期
         * 对应关系就是，CRM 的 1   -> 微盟的 1
         * CRM 的 2,3 -> 微盟的 2
         */
        public void buildCouponUseValidDate(CouponDefinitionParam param) {
            // 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
            Byte validType_1 = 1;
            Byte validType_2 = 2;
            Byte validType_5 = 5;
            // 动态有效期子类型 默认2, 2 N天内有效 4N月内有效 5当月有效 6永久有效
            int subUseTimeType = 2;
            this.useValidDate = new CouponUseValidDate();
            if (param.getValidType() == validType_1) {
                // 固定时间
                this.useValidDate.setUseTimeType(1);
                this.useValidDate.setUseStartTime(param.getValidDateStart().getTime());
                this.useValidDate.setUseEndTime(param.getValidDateEnd().getTime());
            } else if (param.getValidType() == validType_2) {
                // 动态时间
                this.useValidDate.setUseTimeType(2);
                this.useValidDate.setValidDays(param.getValidDay());
                this.useValidDate.setUseDelayDays(0);
                this.useValidDate.setSubUseTimeType(subUseTimeType);
            } else if (param.getValidType() == validType_5) {
                // 动态时间
                this.useValidDate.setUseTimeType(2);
                this.useValidDate.setValidDays(param.getValidDay());
                this.useValidDate.setUseDelayDays(param.getDelayDay());
                this.useValidDate.setSubUseTimeType(subUseTimeType);
            }
        }
    }

    /**
     * 优惠卷其他设置
     */
    @Data
    public static class CouponOtherSetting {

        /**
         * 使用说明: 1:所有门店可用。\n2:所有商品适用。\n3:所有时间适用。\n4:单笔订单不允许叠加使用。\n5:券不可与其他优惠同享。\n6:订单金额满10元可使用券。\n
         * 是否必填：是
         */
        private String explain;

        /**
         * 会员标签集合
         * 是否必填：否
         */
        private List<Long> memberTagIds;

        /**
         * 是否开启库存提醒。true-开启；false-不开启。
         * 是否必填：是
         */
        private Boolean isOpenMessage;

        /**
         * 短信提醒的库存数量
         * 是否必填：否
         */
        private Integer messageStockNum;

        /**
         * 是否为用户打标签。true-打；false-不打。
         * 是否必填：否
         */
        private Boolean hasMemberTag;
    }

    /**
     * 优惠卷创建信息
     */
    @Data
    public static class CouponCreateInfo {

        /**
         * 操作人 wid
         * 是否必填：否
         */
        private Long operatorId;

        /**
         * 来源
         * 是否必填：否
         */
        private String source;
    }


    // ================== 二级类使用 =======================

    /**
     * 优惠卷适用人群信息
     */
    @Data
    public static class CouponCrowd {

        /**
         * 人群数据
         * 是否必填：否
         */
        private String ruleContent;

        /**
         * 选择的数据
         * 是否必填：否
         */
        private String selectedData;
    }

    /**
     * 券使用有效期
     */
    @Data
    public static class CouponUseValidDate {

        /**
         * 时间类型，1：固定，2：动态，3：周期
         * 是否必填：是
         */
        private Integer useTimeType;

        /**
         * 使用开始时间，格式为时间戳，单位：毫秒。 固定有效期时该字段必填
         * 是否必填：否
         */
        private Long useStartTime;

        /**
         * 使用结束时间，格式为时间戳，单位：毫秒。 固定有效期时该字段必填
         * 是否必填：否
         */
        private Long useEndTime;

        /**
         * 动态有效期有效天数
         * 是否必填：否
         */
        private Integer validDays;

        /**
         * 领取后几天生效。单位：天。动态有效期时必填
         * 是否必填：否
         */
        private Integer useDelayDays;

        /**
         * 动态有效期子类型 默认2,2 N天内有效 4N月内有效 5当月有效 6永久有效
         * 是否必填：否
         */
        private Integer subUseTimeType;
    }


    /**
     * 优惠卷部分时段可核销
     */
    @Data
    public static class CouponCycleUseRule {

        /**
         * 1-7 对应 周一-周日
         * 是否必填：是
         */
        private List<Integer> weekDay;

        /**
         * 可用时间段
         * 是否必填：是
         */
        private List<CouponCycleUseRuleTimeSegment> timeSegment;
    }


    // ============== 三级类使用 ================
    @Data
    public static class CouponCycleUseRuleTimeSegment {

        /**
         * 开始时段，单位小时
         * 是否必填：否
         */
        private Integer beginHour;

        /**
         * 开始时段，单位分钟
         * 是否必填：否
         */
        private Integer beginMinute;

        /**
         * 结束时段，单位小时
         * 是否必填：否
         */
        private Integer endHour;

        /**
         * 结束时段，单位分钟
         * 是否必填：否
         */
        private Integer endMinute;
    }
}
