package com.daas.nros.connector.client.model.vo;

import com.daas.nros.connector.client.model.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.math.BigDecimal;

@ToString
public class CouponUseRequestVO extends BaseModel {

    /**
     * 券号
     */
    private String couponCode;

    /**
     * 单号
     */
    private String orderNo;

    /**
     * 会员卡号
     */
    private String memberCode;

    /**
     * 核销说明
     */
    private String description;

    /**
     * 会员核销（1,券核销到会员  0,直接核销到券）
     */
    private Integer isMember;

    @ApiModelProperty(
            value = "优惠类型（1现金，2折扣，3礼品）",
            name = "preferentialType",
            required = false,
            example = ""
    )
    private Byte preferentialType;
    @ApiModelProperty(
            value = "面额",
            name = "money",
            required = false,
            example = ""
    )
    private BigDecimal money;

    @ApiModelProperty(
            value = "核销门店",
            name = "verifyedStoreCode",
            required = false,
            example = ""
    )
    private String verifyedStoreCode;

    @ApiModelProperty(
            value = "核销人(导购)",
            name = "verifyedUser",
            required = false,
            example = ""
    )
    private String verifyedUser;

    public Byte getPreferentialType() {
        return preferentialType;
    }

    public void setPreferentialType(Byte preferentialType) {
        this.preferentialType = preferentialType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getIsMember() {
        return isMember;
    }

    public void setIsMember(Integer isMember) {
        this.isMember = isMember;
    }

    public String getVerifyedStoreCode() {
        return verifyedStoreCode;
    }

    public void setVerifyedStoreCode(String verifyedStoreCode) {
        this.verifyedStoreCode = verifyedStoreCode;
    }

    public String getVerifyedUser() {
        return verifyedUser;
    }

    public void setVerifyedUser(String verifyedUser) {
        this.verifyedUser = verifyedUser;
    }
}
