package com.daas.nros.connector.client.api;

import com.daas.nros.connector.client.model.po.ConnectConfig;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.ConnectConfigVO;

import java.util.List;

public interface ConnectConfigService {

    /**
     * 从db中加载所有t_connect_config表数据进redis
     */
    void refreshRedisAll();

    /**
     * 查询品牌相关参数
     *
     * @param onlineBrandId
     * @return
     */
    ConnectConfig queryByOnlineBrandId(Long onlineBrandId);

    /**
     * 新增企业
     *
     * @param requestVO
     * @return
     */
    Result addConnectConfig(ConnectConfigVO requestVO);

    /**
     * 更新企业及相关配置项
     *
     * @param requestVO
     * @return
     */
    Result updateConnectConfig(ConnectConfigVO requestVO);

    /**
     * 获取所有企业配置项
     *
     * @return
     */
    List<ConnectConfig> getAllConnectConfigList();
}
