package com.daas.nros.connector.client.weimob.model.req.param;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class RightsAssetsParam {

    /**
     * 资产类型
     * 1 :现⾦
     * 2 :积分
     * 3 :余额
     * 4 :储值卡
     * 5 :外部资产
     */
    private Integer assetType;

    /**
     * 资产⽤途
     * 0 :包含所有订单资⾦⽤途
     * 1 :货款-现⾦
     * 2 :运费
     * 3 :税费
     * 4 :⼿续费（暂⽆）
     */
    private Integer assetsTarget;

    //资产⾦额
    private BigDecimal assetAmount;

    //使⽤资产数量，资产类型为积分时必填
    private Integer assetNum;

    //券码类型，1-优惠券；2-优惠码；3-礼品卡
    private Integer couponType;

    //券码编号
    private String couponCode;

    //券码标题
    private String couponTitle;

    //券码抵扣⾦额，分摊后的抵扣
    private BigDecimal couponDeductionAmount;

}
