package com.daas.nros.connector.client.weimob.model.req.param;


import lombok.Data;

import java.util.List;

/**
 * 优惠券作废入参
 */
@Data
public class CouponCancelParam {


    /**
     * 优惠券列表
     */
    private List<CouponOperate> operateCoupons;

    /**
     * CRM 会员编号
     */
    private String memberCode;

    /**
     * 微盟 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
     */
    private Integer vidType;

    /**
     * 微盟 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
     */
    private Long vid;

    /**
     * 微盟 作废类型：1-售后作废；2-码库作废
     */
    private Integer type;

    /**
     * 微盟 券所属会员wid
     */
    private Long wid;


    @Data
    public static class CouponOperate {

        /**
         * CRM 券编号
         */
        private String couponDefinitionCode;

        /**
         * 订单号
         */
        private String orderNo;

        /**
         * 券实例券号
         */
        private String couponCode;

        /**
         * 微盟券模板id
         */
        private Long couponTemplateId;
    }
}
