package com.daas.nros.connector.client.weimob.model.req;

import com.daas.nros.connector.client.weimob.model.req.param.CouponCancelParam;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;


/**
 * CRM -》 WM
 * 作废优惠卷入参
 */
@Data
public class CouponCancelReq {

    /**
     * 用户 ID，是微盟用户身份的唯一标识。可通过 bos/user/search 接口获取 wid。
     * 是否必填：是
     */
    private Long wid;

    /**
     * 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
     * 是否必填：是
     */
    private Integer vidType;

    /**
     * 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
     * 是否必填：是
     */
    private Long vid;

    /**
     * 作废类型：1-售后作废；2-码库作废
     * 是否必填：是
     */
    private Integer type;

    /**
     * 优惠券列表
     * 是否必填：是
     */
    private List<CouponOperate> operateCoupons;

    /**
     * 构建 优惠券列表
     *
     * @param param
     */
    public void buildCouponOperate(CouponCancelParam param) {
        this.operateCoupons = new ArrayList<>();
        param.getOperateCoupons().forEach(coupon -> {
            CouponOperate couponOperate = new CouponOperate();
            couponOperate.setCouponTemplateId(coupon.getCouponTemplateId());
            couponOperate.setCode(coupon.getCouponCode());
            operateCoupons.add(couponOperate);
        });
    }


    // ================  二级子类  ================

    /**
     * 优惠卷信息
     */
    @Data
    public static class CouponOperate {

        /**
         * 优惠券 ID。对应商户后台券列表优惠券 ID。可通过 weimob_crm/coupon/template/search 接口获取。
         * 是否必填：是
         */
        private Long couponTemplateId;

        /**
         * 订单号。售后作废必填。
         * 是否必填：是
         */
        private String orderNo;

        /**
         * 优惠券码值
         * 是否必填：是
         */
        private String code;
    }

}
