package com.daas.nros.connector.client.model.vo;

import com.daas.nros.connector.client.model.base.BaseModel;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @author liuying
 * @date 2018/8/16
 * @description
 */
@ToString
@Data
public class MemberPhoneUpdateRequestVO extends BaseModel {

    private String appKey;
    private String appSecret;

    /**
     * 线下会员id
     */
    private String erpId;
    /**
     * 会员卡号,如果此值为空，将会用 erpId 赋值。
     */
    private String cardNo;

    /**
     * 旧手机号
     */
    @NotBlank
    private String oldMobile;

    /**
     * 新手机号
     */
    @NotBlank
    private String newMobile;


    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getOldMobile() {
        return oldMobile;
    }

    public void setOldMobile(String oldMobile) {
        this.oldMobile = oldMobile;
    }

    public String getNewMobile() {
        return newMobile;
    }

    public void setNewMobile(String newMobile) {
        this.newMobile = newMobile;
    }
}
