package com.daas.nros.connector.client.enums;

public enum ConnectorResponseEnum {
    /**
     * 操作成功！
     */
    SUCCESS(0, "操作成功！"),

    CONNECTION_EXCEPTION(1, "连接异常"),
    /**
     * 操作失败！
     */
    FAILED(100, "操作失败！"),

    /**
     * 储值卡不存在！
     */
    PETCARD_NOT_EXIST_FAILED(101, "查询icrm储值卡不存在！"),
    /**
     * 不存在相应品牌信息或没有品牌参数
     */
    CHECK_BRAND_INFO_CALL_METHOD_EXISTS(101, "不存在相应品牌信息或没有品牌参数"),
    /**
     * 不能调用相应方法
     */
    CHECK_BRAND_METHOD_EXISTS(102, "不能调用相应方法"),
    /**
     * 刷新redis成功
     */
    REFRESH_REDIS(200, "刷新redis成功"),

    REPEATED_REQUEST(3333, "重复请求"),

    NOT_SEND_ERP(103, "不走线下");

    private int code;
    private String message;

    private ConnectorResponseEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}
