package com.daas.nros.connector.client.constants;

import com.daas.nros.connector.client.enums.ConnectorExtandResponseEnum;

import java.util.Arrays;
import java.util.List;


public interface SystemConstant {

    String BRAND_CODE_FOR_FORWORDING = "brandId";

    Boolean VALID = Boolean.TRUE;
    Boolean INVALIE = Boolean.FALSE;

    List<Integer> CONTINUE_CODE_LIST = Arrays.asList(new Integer[]{ConnectorExtandResponseEnum.LOGIN_RETURN_UNDERLINE_MESSAGE_ALL.getCode(), ConnectorExtandResponseEnum.LOGIN_JUMP_TO_OPENCARD_ALL.getCode()});

    /**
     * 男
     */
    Integer MALE = 1;

    /**
     * 女
     */
    Integer FEMALE = 0;

    /**
     * 第一次登陆
     */
    Integer IS_FIRST_LOGIN = 0;

    /**
     * 非第一次登陆
     */
    Integer NOT_FIRST_LOGIN = 1;

    /**
     * 发券失败
     */
    byte COUPON_STATUS_FAILED = 0;

    /**
     * 发券成功
     */
    byte COUPON_STATUS_SUCCESS = 1;

    /**
     * 线下订单
     */
    Integer ORDER_FROM_OFFLINE = 1;

    /**
     * 微商城订单
     */
    Integer ORDER_FROM_ONLINE = 2;

    /**
     * 积分类别,微商城
     */
    Integer ORDER_TYPE_BY_MALL = 1;

    /**
     * 积分类别,积分
     */
    Integer ORDER_TYPE_BY_INTEGRAL = 2;
    /**
     * 连接器客户端是否开启预生产环境方法配置
     */
    String IS_PRE = "1";

}
