package com.daas.nros.connector.client.burgeon.rpc;


import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.weimob.model.vo.VGSerialNumberVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.connector.name}", path = "${feign.client.connector.path}/vgSerialNumber")
public interface VGSerialNumberServiceFeign {

    /**
     * 获取号
     *
     * @return
     */
    @RequestMapping(value = "getSerialNumber", method = RequestMethod.GET)
    String getSerialNumber(String prefix);

    /**
     * 获取卡号并保存流水
     *
     * @param vgSerialNumberVo
     * @return
     */
    @RequestMapping(value = "getSerialNumberAndSaveRecord", method = RequestMethod.POST)
    ResponseData<String> getRedisNoAndSaveSerialNumberRecord(@RequestBody VGSerialNumberVo vgSerialNumberVo);
}
