package com.daas.nros.connector.client.api.base;


import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.CouponBatchBindRequestVO;
import com.daas.nros.connector.client.model.vo.CouponBindRequestVO;

public interface CouponBindService {

    /**
     * 批量绑定线下券
     *
     * @param requestVO
     * @return
     */
    default Result batchBindCoupon(CouponBatchBindRequestVO requestVO) {
        return Result.returnStr(0, "default批量绑定线下优惠券成功");
    }

    /**
     * 批量绑定线下券回调
     *
     * @param requestVo
     * @throws Exception 异常
     */
    void callbackBindCoupon(CouponBatchBindRequestVO requestVo) throws Exception;

    /**
     * 绑定线下券单张
     *
     * @param requestVO
     * @return
     */
    default Result singleBindCoupon(CouponBindRequestVO requestVO) {
        return Result.returnStr(0, "default单张绑定线下优惠券成功");
    }

    /**
     * 绑定线下券单张回调
     *
     * @param requestVo
     * @throws Exception 异常
     */
    void callbackSingleBindCoupon(CouponBindRequestVO requestVo) throws Exception;
}
