package com.daas.nros.connector.weimob.model.req.param;

import lombok.Data;

import java.util.List;

@Data
public class UseAcceptTypeDTO {

    /**
     * 适用门店类型：1-全部门店适用；2-指定区域适用；3-指定门店适用。
     * 是否必填：是
     */
    private Integer acceptStoreType;

    /**
     * 适用区域vid或门店vid
     * 是否必填：否
     */
    private List<Long> acceptStoreIds;

    /**
     * 适用商品类型：1-全部商品适用；2-部分商品适用;3-部分分组适用;4-部分类目适用
     * 是否必填：是
     */
    private Integer acceptGoodsType;

    /**
     * 商品或分组或类目ID
     * 是否必填：否
     */
    private List<Long> acceptGoodsIds;

    /**
     * 是否存在排除商品。true-存在；false-不存在。默认false
     * 是否必填：否
     */
    private Boolean existExcludeGoods;

    /**
     * 排除商品ID
     * 是否必填：否
     */
    private List<Long> excludeGoodsIds;

    /**
     * 是否包含门店自建商品。true-包含；false-不包含。
     * 是否必填：否
     */
    private Boolean includeStoreGoods;

    /**
     * 是否排除门店 指定全部门店适用时有效
     * 是否必填：否
     */
    private Boolean existExcludeStore;

    /**
     * 指定排除门店 设置为全部门店适用时可指定排除门店
     * 是否必填：否
     */
    private List<Long> excludeStoreIds;

}
