package com.daas.nros.connector.weimob.model.req.param;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;


/**
 * 券模板使用规则
 */
@Data
public class CouponTemplateUseRule {

    /**
     * 是否使用有门槛。true-使用；false-不使用。门槛包括满元门槛和满件门槛
     * 是否必填：是
     */
    private Boolean hasUseThreshold;

    /**
     * 是否开启满元门槛。true-开启；false-不开启。
     * 是否必填：是
     */
    private Boolean canCashTicket;

    /**
     * 商品金额满元门槛。例如满5元使用券，开启满元门槛时该字段必填。
     * 是否必填：否
     */
    private Integer goodsCashTicket;

    /**
     * 叠加规则，默认没有
     * 是否必填：是
     */
    private UseRoleSuperpositionRule superpositionRule;

    /**
     * 下单可同时使用抵扣：1-积分；2-余额；3-储值卡。
     * 是否必填：是
     */
    private List<Integer> orderDeductList;

    /**
     * 单笔订单叠加上限
     * 是否必填：是
     */
    private Boolean isAllTimeUse;

    /**
     * 可共享的优惠
     * 是否必填：是
     */
    private UseRoleCanUseDiscount canUseDiscount;

    /**
     * 是否是全部核销场景。true-是；false-不是。
     * 是否必填：是
     */
    private Boolean isAllUseScene;

    /**
     * 核销场景：商城、堂食、外卖、酒旅，目前只有商城
     * 是否必填：是
     */
    private CouponTemplateAllScene allSceneDTO;

    /**
     * 适用类型信息
     * 是否必填：是
     */
    private UseAcceptTypeDTO acceptTypeDTO;

    /**
     * 否开启满件门槛。true-开启；false-不开启。
     * 是否必填：是
     */
    private Boolean canGoodsNumber;

    /**
     * 开启满件门槛最低数量
     * 是否必填：否
     */
    private Integer minGoodsNumber;

    /**
     * 开启满件门槛最高数量
     */
    private Integer maxGoodsNumber;


    /**
     * 构建 优惠券叠加规则
     *
     * @param param
     */
    public void buildUseRoleSuperpositionRule(CouponDefinitionParam param) {
        this.superpositionRule = new UseRoleSuperpositionRule();
        this.superpositionRule.setIsSuperposition(param.getIsSuperposition());
    }

    /**
     * 构建 可共享的优惠
     *
     * @param param
     */
    public void buildUseRoleCanUseDiscount(CouponDefinitionParam param) {
        // 是否与其他活动共享优惠。true-共享；false-不共享。固定值 false
        boolean canUseWithOtherDiscount = false;
        this.canUseDiscount = new UseRoleCanUseDiscount();
        this.canUseDiscount.setCanUseWithOtherDiscount(canUseWithOtherDiscount);
    }


    /**
     * 构建 核销场景：商城、堂食、外卖、酒旅，目前只有商城
     *
     * @param param
     */
    public void buildCouponTemplateAllScene(CouponDefinitionParam param) {
        // 是否与其他活动共享优惠。true-共享；false-不共享。固定值 false
        this.allSceneDTO = new CouponTemplateAllScene();
    }

    /**
     * 构建 适用类型信息
     *
     * @param param
     */
    public void buildUseAcceptTypeDTO(CouponDefinitionParam param) {
        this.acceptTypeDTO = new UseAcceptTypeDTO();
        if (param.getApplianceStoreType() == 1) {
            // 全部门店
            this.acceptTypeDTO.setAcceptStoreType(1);
        } else if (param.getApplianceStoreType() == 2) {
            // 部分门店
            this.acceptTypeDTO.setAcceptStoreType(3);
            this.acceptTypeDTO.setAcceptStoreIds(param.getWmStoreIdList());
        } else if (param.getApplianceStoreType() == 3 || param.getApplianceStoreType() == 4) {
            // 区域
            this.acceptTypeDTO.setAcceptStoreType(2);
            this.acceptTypeDTO.setAcceptStoreIds(param.getWmStoreIdList());
        }
        if (param.getApplianceCommodityType() == 1) {
            // 全部商品
            this.acceptTypeDTO.setAcceptGoodsType(1);
        } else if (param.getApplianceCommodityType() == 2) {
            // 部分商品
            this.acceptTypeDTO.setAcceptGoodsType(2);
            this.acceptTypeDTO.setAcceptGoodsIds(param.getGoodsIdList());
        }
        if (CollectionUtils.isNotEmpty(param.getExcludeStoreIds())) {
            // 排除商品id
            this.acceptTypeDTO.setExistExcludeGoods(Boolean.TRUE);
            this.acceptTypeDTO.setExcludeGoodsIds(param.getExcludeStoreIds());
        }
    }
}
