package com.daas.nros.connector.weimob.model.req.param;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 券模板优惠规则
 */
@Data
public class CouponTemplateReduceRule {

    /**
     * 减免的类型，包括：0-无门槛固定减免金额；1-固定门槛减免金额；2-每满多少减多少。
     * 是否必填：否
     */
    private Integer reducePriceType;

    /**
     * 代金券减免金额，代金券必填
     * 是否必填：否
     */
    private BigDecimal cashTicketAmt;

    /**
     * 计价方式，包括：1-市场价；2-销售价；默认销售价 ；兑换券无此字段
     * 是否必填：是
     */
    private Integer pricingType;

    /**
     * 成本类型： 1-固定金额；2-百分比 (传显示的数值)
     * 是否必填：是
     */
    private Integer couponCostType;

    /**
     * 成本金额 or 比例值
     * 是否必填：是
     */
    private Integer couponCost;

    /**
     * 成本分摊归属组织
     * 是否必填：否
     */
    private String costOfOrganization;

    /**
     * 成本分摊归属门店
     * 是否必填：否
     */
    private Integer costOfStore;

    /**
     * 折扣券减免折扣（折扣券必填）取值范围[1,9.9] ，例如：9折则传9。
     * 是否必填：否
     */
    private Double discount;

    /**
     * 折扣上限类型：1-不封顶；2-按件封顶；3-按金额封顶
     * 是否必填：否
     */
    private Integer discountLimitType;

    /**
     * 折扣券优惠上限值
     * 是否必填：否
     */
    private String discountLimitValue;

}
