package com.daas.nros.connector.model.vo;


import com.daas.nros.connector.model.base.BaseModel;
import lombok.Data;
import lombok.ToString;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@Data
@ToString
public class MemberOpenCardRequestVO extends BaseModel {


    /**
     * 卡号
     */
    private String cardNo;
    /**
     * 微信用户的openId
     */
    private String openId;

    /**
     * 微信用户的unionId
     */
    private String unionId;

    /**
     * 手机号
     */
//    @NotBlank(message = "手机号不允许为空")
//    @Pattern(regexp="^[1][3,4,5,7,8,9][0-9]{9}$",message = "手机号格式不正确")
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 等级Code
     */
//    @NotBlank(message = "等级code不允许为空")
    private String levelCode;

    /**
     * 开卡时间
     */
    private String openCardTime;

    /**
     * 会员性别(1男   0女)
     */
    private Integer gender;

    /**
     * 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    /**
     * 开卡门店编号
     */
//    @NotBlank(message = "开卡门店不允许为空")
    private String openStoreCode;

    /**
     * 开卡导购编号
     */
    private String openGuideCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 有效期
     */
    private String effectiveTime;

    /**
     * 开卡来源
     */
    private String source;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 开卡区别来源UR
     */
    private String registerType;

    /**
     * 服务门店
     */
    private String serviceStoreCode;

    /**
     * 服务导购
     */
    private String serviceGuideCode;

    /**
     * 密码UR
     */
    private String password;

    private String taobaoNick;

    /**
     * 361备注
     */
    private String remark;

    /**
     * 361身份证号
     */
    private String idCard;

    /**
     * 会员名称
     */
    private String taobaoName;

    /**
     * 手机区域号
     */
    private String phoneAreaCode;

    /**
     * 有赞openId
     */
    private String yzOpenId;

    /**
     * 默认开卡门店
     */
    private String defaultOpenStoreCode;

    /**
     * 默认开卡导购
     */
    private String defaultOpenGuideCode;

    /**
     * 雷朵 开卡导购名称
     */
    private String openGuideName;

    /**
     * 雷朵 标志
     */
    private Boolean radoFlag = Boolean.FALSE;

    /**
     * 雷朵 更新时间
     */
    private String offlineUpdateDate;

    /**
     * 会员唯一标识
     */
    private String erpId;

}
