package com.daas.nros.connector.burgeon.model.req;

import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * @program: connector
 * @description: 新增券定义
 * @author: Liu Xinpeng
 * @create: 2021-03-02 15:19
 **/
@Data
@Builder
public class SnyCouponInfoReq {


    private String appKey;

    private String appSecret;

    /**
     * 活动编号
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 有效期类型
     */
    private Integer validType;

    /**
     * 活动开始时间
     */
    private String validStartAt;

    /**
     * 活动结束时间
     */
    private String validEndAt;

    /**
     * 有效天数
     */
    private Integer validDay;

    /**
     * 作用级别
     */
    private Integer level;

    /**
     * 使用条件
     */
    private Long condition;

    /**
     * 优惠方式
     */
    private Integer discountType;

    /**
     * 优惠券
     */
    private Long discountValue;

    /**
     * 优惠使用对象
     */
    private Integer discountTarget;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 限领数量
     */
    private Integer limitQuantity;

    /**
     * 商家编号
     */
    private String shopId;

    /**
     * 状态 0:未启用 1：已启用  2：已无效
     */
    private Integer status;

    /**
     * 指定商户
     */
    private List<String> shopCodeList;

    /**
     * 指定商品
     */
    private List<String> skuCodeList;

    /**
     * 指定商品 20220509
     */
    private List<String> itemCodeList;

    /**
     * 变更类型（默认为A） A：新增 M：修改（⽬前⽀持修改适⽤商品、禁⽤商品） D：作废
     */
    private String changeType;

}