package com.daas.nros.connector.weimob.model.req.param;


import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 优惠券核销入参
 */
@Data
public class CouponUseParam {

    /**
     * 订单总金额
     */
    private BigDecimal orderAmount;


    /**
     * 优惠券列表
     */
    private List<OperateCoupon> operateCoupons;

    /**
     * CRM 券所属会员code
     */
    private String memberCode;

    /**
     * 微盟  券所属会员wid
     */
    private Long wid;

    /**
     * 组织架构节点ID。可以通过B端页面店铺/店铺设置/组织架构找到该ID。根据配置获取
     */
    private Long vid;

    /**
     * 券
     */
    @Data
    public static class OperateCoupon {

        /**
         * CRM 优惠券定义code
         */
        private String couponDefinitionCode;

        /**
         * 优惠券实例code
         */
        private String code;

        /**
         * 实际优惠金额
         */
        private BigDecimal amount;

        /**
         * 微盟 券模板id
         */
        private Long couponTemplateId;

    }
}
