package com.daas.nros.connector.weimob.model.req;

import lombok.Data;

@Data
public class MemberLabelAttrReq extends WmBaseReq {

    //标签组 ID，标签组的唯一标识，是商家创建标签组时自动生成得标签组编号。可通过 weimob_cdp/tag/getList 接口获取该 ID。
    private Long tagId;

    //标签名称，商家创建标签时设置的名称
    private String attrName;

    //组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4-部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。
    private Integer vidType;

    //组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
    private Long vid;

    //操作来源。支持的来源包括：1-商家后台；2-openAPI；3-新云APP。不传默认为 1。
    private Integer operationSource;
}
