package com.daas.nros.connector.model.vo;


import com.daas.nros.connector.model.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @Author: xiao.shu
 * @Date: 2019/7/1 14:09
 * @Description: 批量
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
@ToString
public class StorageCardRequestVO extends BaseModel {

    @ApiModelProperty(
            value = "用户卡号",
            name = "cardCode",
            required = false,
            example = ""
    )
    private String cardCode;

    @ApiModelProperty(
            value = "姓名",
            name = "vipName",
            required = false,
            example = ""
    )
    private String vipName;

    @ApiModelProperty(
            value = "性别，男女",
            name = "sex",
            required = false,
            example = ""
    )
    private String sex;

    @ApiModelProperty(
            value = "手机号",
            name = "phone",
            required = false,
            example = ""
    )
    private String phone;

    @ApiModelProperty(
            value = "变更金额",
            name = "updateBalance",
            required = false,
            example = ""
    )
    private BigDecimal updateBalance;

    @ApiModelProperty(
            value = "转赠额/新增额",
            name = "balance",
            required = false,
            example = ""
    )
    private BigDecimal balance;

    @ApiModelProperty(
            value = "转赠人姓名",
            name = "transferPerson",
            required = false,
            example = ""
    )
    private String transferPerson;

    @ApiModelProperty(
            value = "受赠人姓名",
            name = "donee",
            required = false,
            example = ""
    )
    private String donee;

    @ApiModelProperty(
            value = "储值卡号",
            name = "storedCardNo",
            required = false,
            example = ""
    )
    private String storedCardNo;

    @ApiModelProperty(
            value = "单据编号",
            name = "documentNo",
            required = false,
            example = ""
    )
    private String documentNo;

    @ApiModelProperty(
            value = "是否返回 0 未返回  1返回",
            name = "backType",
            required = false,
            example = ""
    )
    private String backType;

    @ApiModelProperty(
            value = "1.新增，2.编辑，3.转赠 4.受赠 5.消费 6.退回",
            name = "type",
            required = false,
            example = ""
    )
    private String type;

    @ApiModelProperty(
            value = "备注",
            name = "remark",
            required = false,
            example = ""
    )
    private String remark;

    @ApiModelProperty(
            value = "创建人",
            name = "creater",
            required = false,
            example = ""
    )
    private String creater;

    @ApiModelProperty(
            value = "更改人",
            name = "modifier",
            required = false,
            example = ""
    )
    private String modifier;

    @ApiModelProperty(
            value = "企业编号",
            name = "corpCode",
            required = false,
            example = ""
    )
    private String corpCode;

    public String getCardCode() {
        return cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    public String getVipName() {
        return vipName;
    }

    public void setVipName(String vipName) {
        this.vipName = vipName;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public BigDecimal getUpdateBalance() {
        return updateBalance;
    }

    public void setUpdateBalance(BigDecimal updateBalance) {
        this.updateBalance = updateBalance;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public String getTransferPerson() {
        return transferPerson;
    }

    public void setTransferPerson(String transferPerson) {
        this.transferPerson = transferPerson;
    }

    public String getDonee() {
        return donee;
    }

    public void setDonee(String donee) {
        this.donee = donee;
    }

    public String getStoredCardNo() {
        return storedCardNo;
    }

    public void setStoredCardNo(String storedCardNo) {
        this.storedCardNo = storedCardNo;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getBackType() {
        return backType;
    }

    public void setBackType(String backType) {
        this.backType = backType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
}
