package com.daas.nros.connector.weimob.model.vo;

import com.alibaba.fastjson.JSONArray;
import lombok.Builder;
import lombok.Data;

@Builder
@Data
public class OfflineIntegralOrderRequestVo {

    /**
     * brandCode	是	String	品牌俱乐部code
     * cardNo	是	String	集团会员卡号
     * orderNo	是	String	平台订单号
     * orderTime	是	String	下单时间 yyyy-MM-dd HH:mm:ss
     * recvConsignee	是	String	收货联系人
     * recvMobile	是	String	收货人手机
     * recvAddress	是	String	收货人地址
     * recvProvince	是	String	收货人省份
     * recvCity	是	String	收货人城市
     * recvCounty	否	String	收货人区县
     * orderRemark	否	String	订单备注
     * useIntegral	是	int	使用积分
     * logisticsCode	否	String	物流公司编码
     * logisticsName	否	String	物流公司名称
     */
    private String brandCode;
    private String cardNo;
    private String orderNo;
    private String orderTime;
    private String recvConsignee;
    private String recvMobile;
    private String recvAddress;
    private String recvProvince;
    private String recvCity;
    private String recvCounty;
    private String orderRemark;
    private Integer useIntegral;
    private String logisticsCode;
    private String logisticsName;

    /**
     * orderDetailNo	是	String	平台子单号
     * skuCode	是	String	条码编码
     * quantity	是	int	数量
     * useIntegral	否	int	明细使用积分
     */
    private JSONArray orderDetails;
}
