package com.daas.nros.connector.weimob.model.req;


import lombok.Data;

/**
 * CRM -> WM
 * 会员领卷,入参
 */
@Data
public class CouponBandMemberReq {

    /**
     * 领券时间，时间戳，单位毫秒。
     * 是否必填：是
     */
    private Long acquireTime;

    /**
     * 优惠券 ID，可以通过 weimob_crm/coupon/template/search 接口获取该 ID。
     * 是否必填：是
     */
    private Long couponTemplateId;

    /**
     * 券码值，即同步的外部券 code。
     * 是否必填：是
     */
    private String code;

    /**
     * 用户 ID，是微盟用户身份的唯一标识。可通过 bos/user/search 接口获取 wid。
     * 是否必填：是
     */
    private Long wid;

    /**
     * 开始时间，格式为时间戳，单位毫秒。
     * 是否必填：是
     */
    private Long expireStartTime;

    /**
     * 过期时间，格式为时间戳，单位毫秒。
     * 是否必填：是
     */
    private Long expireEndTime;

    /**
     * 组织架构节点 ID。组织的唯一标识，是创建组织时自动生成的 ID，可以通过 bos/organization/getList 接口获取该 ID。
     * 是否必填：是
     */
    private Long vid;
}
