package com.daas.nros.connector.model.vo;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@Data
@ToString
public class MemberInfoUpdateRequestVO extends BaseModel {


    private String erpId;
    /**
     * 微信用户的openId
     */
    private String openId;

    /**
     * 微信用户的unionId
     */
    private String unionId;

    /**
     * 手机号
     */
//    @NotBlank(message = "手机号码不允许为空")
//    @Pattern(regexp="^[1][3,4,5,7,8,9][0-9]{9}$",message = "手机号格式不正确")
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 等级Code
     */
//    @NotBlank(message = "等级code不允许为空")
    private String levelCode;

    /**
     * 会员性别(1男   0女)
     */
    private String gender;

    /**
     * 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 线下卡号
     */
    private String offlineCardNo;

    /**
     * 开卡门店编号
     */
    private String openStoreCode;

    /**
     * 开卡导购编号
     */
    private String openGuideCode;

    /**
     * 服务门店编号
     */
    private String serviceStoreCode;

    /**
     * 服务导购编号
     */
    private String serviceGuideCode;


    /**
     * 业务唯一编号
     */
    private String memberUUID;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 自定义拓展字段,格式,json字符串
     */
    private String extend;

    /**
     * 当前重试次数
     */
    private int retryCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 身份证号 361
     */
    private String idCard;

    /**
     * 全渠道会员卡ids
     */
    private String allChannelIds;

    /**
     * cyyz
     * 绑卡时间回写线下
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bindCardTime;

    /**
     * 手机区域号
     */
    private String phoneAreaCode;

    /**
     * 有赞openId
     */
    private String yzOpenId;

    /**
     * 雷朵 rado-ds服务
     */
    private Boolean radoFlag = Boolean.FALSE;

    /**
     * 雷朵 新等级编号
     */
    private String newLevelCode;

    /**
     * 雷朵 新等级名称
     */
    private String newLevelName;

    /**
     * 雷朵 导购名称
     */
    private String serviceGuideName;

    /**
     * 雷朵 sap更新时间
     */
    private String modifiedTime;

}
