package com.daas.nros.connector.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

/**
 * @author admin
 * @date
 */
@ToString
public class ConnectConfigVO {

    @ApiModelProperty(
            value = "线上品牌id",
            name = "onlineBrandId",
            required = true,
            example = "1"
    )
    private Long onlineBrandId;

    @ApiModelProperty(
            value = "线下品牌编号",
            name = "offlineBrandCode",
            required = true,
            example = "001"
    )
    private String offlineBrandCode;

    @ApiModelProperty(
            value = "品牌名称",
            name = "brandName",
            required = true,
            example = "杉杉"
    )
    private String brandName;

    @ApiModelProperty(
            value = "线下连接器地址",
            name = "domain",
            required = true,
            example = "http://192.168.2.222:3323/rest"
    )
    private String domain;

    @ApiModelProperty(
            value = "有效期,天数",
            name = "validDayNumber",
            required = true,
            example = "365"
    )
    private Integer validDayNumber;

    @ApiModelProperty(
            value = "线下企业编号",
            name = "offlineCompanyCode",
            required = true,
            example = "P40000"
    )
    private String offlineCompanyCode;

    public Long getOnlineBrandId() {
        return onlineBrandId;
    }

    public void setOnlineBrandId(Long onlineBrandId) {
        this.onlineBrandId = onlineBrandId;
    }

    public String getOfflineBrandCode() {
        return offlineBrandCode;
    }

    public void setOfflineBrandCode(String offlineBrandCode) {
        this.offlineBrandCode = offlineBrandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getValidDayNumber() {
        return validDayNumber;
    }

    public void setValidDayNumber(Integer validDayNumber) {
        this.validDayNumber = validDayNumber;
    }

    public String getOfflineCompanyCode() {
        return offlineCompanyCode;
    }

    public void setOfflineCompanyCode(String offlineCompanyCode) {
        this.offlineCompanyCode = offlineCompanyCode;
    }
}
