package com.daas.nros.connector.weimob.model.req.param;

import lombok.Data;

import java.util.Map;

@Data
public class MemberInfo {

    //  手机号。如果同时传入appid+openid/unionid，该字段可不填 。
    private String phone;

    //手机区号。海外手机号必传该字段，字段类型纯数字，不需要+号。
    private String regionCode;

    //用户unionId。与指定的appId能表示一个用户的身份。当手机号或者openId为空时，必传。
    private String unionId;

    //客户的openId。与指定的appId能表示一个用户的身份。当手机号或者unionId为空时，必传。
    private String openId;

    //小程序/公众号appId，需要和微盟后台主体保持一致。使用unionid/openId 作为标识导入客户时，该字段必填。
    private String appId;

    //客户渠道类型。支持的类型包括：0-公众号；1-小程序；2-口碑；3-H5登陆；4-百度小程序；5-商家后台(导入/新增/发卡)；6-自有APP(C端免登APP&H5)；7-企业微信(新增联系人)；8-自助屏；9-字节跳动；11-字节跳动小程序；12-支付宝；13-微盟直播小程序；14-qq小程序；15-快手小程序；16-小红书小程序。
    private Integer appChannel;

    //姓名。长度不大于20。不传值时为空。
    private String userName;

    // 性别。支持的性别选项包括：0-未知；1-男；2-女。不传值时为空。
    private Integer gender;

    //生日。要求格式为时间戳，单位：毫秒。不传值时为空。
    private Long birthday;

    //证件号。不传值时为空。
    private String identityCardNum;

    // 教育水平。支持的教育水平类型包括：1-小学；2-初中；3-高中；4-大专；5-大学；6-研究生；7-博士。不传值时为空。
    private String education;

    // 收入水平。支持的收入水平选项包括：1-(5万以下)；2-(5万-15万)；3-(15万-30万)；4-(30万以上)。不传值时为空。
    private String income;

    // 行业。支持的行业类型包括：1-(IT/互联网/通信/电子)；2-(金融/投资/财会)；3-(市场/销售/客服)；4-(广告/媒体/出版/艺术)；5-(人事/行政/管理)；6-(消费品/贸易/物流)；7-(建筑/房产/物业)；
    // 8-(生产/制造/营运/采购)；9(生物/制药/医疗/护理 )；10-(咨询/法律/认证)；11-( 教育/培训/翻译)；12-(科研/环保/休闲/其他)。不传值时为空。
    private String industry;

    // 爱好。支持的爱好类型包括：1-游戏；2-阅读；3-音乐；4-运动；5-动漫；6-旅行；7-家居；8-曲艺；9-宠物；10-美食；11-娱乐；12-电影；13-电视剧；14-健康养生；15-数码；16-其他。不传值时为空。
    private String hobby;

    //省。不传值时为空。
    private String province;

    //市。不传值时为空。
    private String city;

    //区
    private String area;

    //详细地址
    private String address;

    //归属门店名称
    private String belongVidName;

    //归属门店
    private Long belongVid;

    //会员卡号
    private String customCardNo;

    //会员等级名称。不传值时为空。
    private String levelName;

    // 成长值。不传值时为空
    private Integer growth;

    //可用余额。可用余额应大于等于0。不传值时为空。
    private Integer balance;

    //累计余额。累计余额应大于等于0。不传值时为空。
    private Integer totalBalance;

    //可用积分。可用积分需要大于等于0，且不应大于累计积分。不传值时为空。
    private Integer point;

    // 累计积分。累计积分需要大于等于0。
    private Integer totalPoint;

    //标签1: 属性1：属性2 ; 标签2：属性1
    //    多个标签用 ；分割，属性用 ：分割，不能大于 99个。且传值只能选择微盟已存在的标签。不传值时为空。
    private String tag;

    // 绑定导购手机号。绑定导购的门店需要与归属门店保持一致。不传值时为空。
    private String guiderPhone;

    /**
     * 扩展字段
     * sourceVid  领卡门店 ID
     * becomeMemberTime     开卡时间
     * membershipCardChannel  开卡渠道
     */
    private Map<String, Object> extMap;

    // 领卡门店
    private Long sourceVid;

    //
    private String userKey;

    //开卡时间。也是成为会员时间。
    private long becomeMemberTime;

    //开卡渠道。支持的开卡渠道类型包括：-1-其他;0-微信公众号;1-微信小程序;2-支付宝小程序;3-H5登陆;
    // 4-百度小程序;5-后台发卡(导入/新增/发卡）;6-自有APP（C端免登APP&H5）;7-线下开卡;8-小红书小程序;9-小红书H5;10-QQ小程序;11-QQH5;12-快手小程序;13-快手H5;14-抖音;15-第三方开卡;16-淘宝;17-京东。不传值时为5。
    private Integer membershipCardChannel;


}
