package com.daas.nros.connector.util;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

/**
 * @author xz
 * @date 2020/3/9 11:55
 **/
@Slf4j
public class HttpClientUtil {

    private static int CONNECT_TIME_OUT = 30 * 1000;

    public static String doPost(String url, String postData) {
        HashMap<String, String> map = new HashMap<>();
        map.put("Content-type", "application/json;charset=utf-8");
        return dopost(url, postData, map);
    }

    /**
     * @param url      发送请求的 URL
     * @param postData 需要post的数据
     * @param headers  请求头
     * @return 所代表远程资源的响应结果
     */
    public static String dopost(String url, String postData, Map<String, String> headers) {
        HttpPost post = new HttpPost();
        CloseableHttpResponse response = null;
        try {
            post.setURI(new URI(url));
            if (StringUtils.isNotBlank(postData)) {
                post.setEntity(new StringEntity(postData, StandardCharsets.UTF_8));
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClientUtil.builderByUrl(url, CONNECT_TIME_OUT);
            response = httpClient.execute(post);
            return EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        } catch (SocketTimeoutException e) {
            throw new BizException(SysResponseEnum.NETWORK_ERROR.getCode(), "响应超时");
        } catch (ConnectTimeoutException e) {
            throw new BizException(SysResponseEnum.NETWORK_ERROR.getCode(), "响应超时");
        } catch (Exception e) {
            log.info("post error:{}", e);
            throw new RuntimeException("got an error from HTTP for url:" + url, e);
        } finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            post.releaseConnection();
        }
    }

    /**
     * @param url      发送请求的 URL
     * @param postData 需要post的数据
     * @param headers  请求头
     * @return 所代表远程资源的响应结果
     */
    public static String dopostTimeOut(String url, String postData, Map<String, String> headers) {
        HttpPost post = new HttpPost();
        CloseableHttpResponse response = null;
        try {
            post.setURI(new URI(url));
            if (StringUtils.isNotBlank(postData)) {
                post.setEntity(new StringEntity(postData, "UTF-8"));
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClientUtil.builderByUrl(url, 100);
            response = httpClient.execute(post);
            return EntityUtils.toString(response.getEntity(), "UTF-8");
        } catch (Exception e) {
            log.info("post error:{}", e);
            throw new RuntimeException("got an error from HTTP for url:" + url + "   " + e);
        } finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            post.releaseConnection();
        }
    }

    private static CloseableHttpClient builderByUrl(String url, int connectTimeOut) throws Exception {

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(connectTimeOut)
                .setConnectionRequestTimeout(connectTimeOut)
                .setSocketTimeout(connectTimeOut)
                .build();
        log.info("url:{}", url);
        if (StringUtils.isNotBlank(url) && url.contains("https://dalaran-runtime-qas.mall-qas.vgrassstudio.com:214432")) {
            log.info("忽略ssl证书");
            return buildSSLCloseableHttpClient(requestConfig);
        }
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    private static CloseableHttpClient buildSSLCloseableHttpClient(RequestConfig requestConfig)
            throws Exception {
        TrustStrategy trustSelfSignedStrategy = ((x509Certificates, s) -> true);

        HostnameVerifier hv = (urlHostName, session) -> {
            log.info("Warning: URL Host: " + urlHostName + " vs. "
                    + session.getPeerHost());
            return true;
        };

        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, trustSelfSignedStrategy).build();
        // ALLOW_ALL_HOSTNAME_VERIFIER:这个主机名验证器基本上是关闭主机名验证的,实现的是一个空操作，并且不会抛出javax.net.ssl.SSLException异常。
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
                sslContext, hv);
        return HttpClients.custom().setSSLSocketFactory(sslsf).setDefaultRequestConfig(requestConfig).build();
    }

    public static String doget(String url, Map<String, String> headers) {
        HttpGet get = new HttpGet();
        HttpResponse response = null;
        try {
            get.setURI(new URI(url));
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpClient httpClient = HttpClients.createDefault();
            response = httpClient.execute(get);
            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            throw new RuntimeException("got an error from HTTP for url:" + url, e);
        } finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            get.releaseConnection();
        }
    }


    public static void main(String[] args) {

    }

    private void trustAllHttpsCertificates() throws Exception {
        javax.net.ssl.TrustManager[] trustAllCerts = new javax.net.ssl.TrustManager[1];
        javax.net.ssl.TrustManager tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext
                .getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(sc
                .getSocketFactory());
    }

    class miTM implements javax.net.ssl.TrustManager,
            javax.net.ssl.X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(
                X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(
                X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(
                X509Certificate[] certs, String authType)
                throws CertificateException {
            return;
        }

        @Override
        public void checkClientTrusted(
                X509Certificate[] certs, String authType)
                throws CertificateException {
            return;
        }
    }

}
