package com.daas.nros.connector.enums;

public enum StringBrandCode {

    jh("JH"),
    vg("VG-CLUB"),
    tw("TW-CLUB"),
    mall("MALL-CLUB"),
    yj("YJ-CLUB");

    private String value;

    StringBrandCode(String value) {
        this.value = value;
    }

    public static String getValue(StringBrandCode brandCode) {
        return brandCode.value;
    }

    // 为了使注解校验器能生效，必须有这个方法
    public static StringBrandCode toEnum(String value) {
        switch (value) {
            case "JH":
                return StringBrandCode.jh;
            case "VG-CLUB":
                return StringBrandCode.vg;
            case "TW-CLUB":
                return StringBrandCode.tw;
            case "MALL-CLUB":
                return StringBrandCode.mall;
            case "YJ-CLUB":
                return StringBrandCode.yj;
            default:
                throw new IllegalArgumentException("invalid value .");
        }
    }

    public String getValue() {
        return this.value;
    }

}
