/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.wechat.callback.server.service.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.wechatenterprise.service.common.HttpUtil;
import com.bizvane.wechatenterprise.service.entity.po.WxQyApplication;
import com.bizvane.wechatenterprise.service.entity.vo.AuthCorpInfoVo;
import com.bizvane.wechatenterprise.service.entity.vo.ContactStuffInfoVo;
import com.bizvane.wechatenterprise.service.entity.vo.ExternalContactInfoVo;
import com.daas.nros.wechat.callback.server.tool.AesException;
import com.daas.nros.wechat.callback.server.tool.WXBizMsgCrypt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WeChatTools {
    private static final Logger logger = LoggerFactory.getLogger(WeChatTools.class);

    public String inputStream2String(InputStream in) throws IOException {
        if (in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));){
            String s;
            while ((s = br.readLine()) != null) {
                out.append(s);
            }
        }
        return out.toString();
    }

    public String decryptMsg(HttpServletRequest request, String postData, WxQyApplication wxQyApplication) {
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wxQyApplication.getToken(), wxQyApplication.getEncodingAeskey(), wxQyApplication.getSuiteId());
            return wxcpt.DecryptMsg(msg_signature, timestamp, nonce, postData);
        }
        catch (AesException e) {
            logger.error("decryptMsg error :" + e.getMessage());
            return "";
        }
    }

    public String validateSignature(HttpServletRequest request, WxQyApplication wxQyApplication) {
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wxQyApplication.getToken(), wxQyApplication.getEncodingAeskey(), wxQyApplication.getAppCorpId());
            return wxcpt.VerifyURL(msg_signature, timestamp, nonce, echostr);
        }
        catch (AesException e) {
            logger.error("validateSignature error :" + e.getMessage());
            return "";
        }
    }

    public Map<String, String> getPostMap(String msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)msg);
        }
        catch (DocumentException e) {
            logger.error("getPostMap parseText error :" + e.getMessage());
        }
        if (document != null) {
            Element root = document.getRootElement();
            List listElement = root.elements();
            for (Element e : listElement) {
                map.put(e.getName(), e.getTextTrim());
            }
        }
        return map;
    }

    public String getSuitAccessToken(WxQyApplication wxQyApplication) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("suite_id", wxQyApplication.getSuiteId());
        map.put("suite_secret", wxQyApplication.getSecret());
        map.put("suite_ticket", wxQyApplication.getSuiteTicket());
        String result = null;
        try {
            result = HttpUtil.post((String)"https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token", (String)JSON.toJSONString(map));
            logger.info("getSuitAccessToken result : {}" + result);
        }
        catch (IOException e) {
            logger.error("getSuitAccessToken error :" + e.getMessage());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject.getString("suite_access_token");
    }

    public AuthCorpInfoVo getAuthCorpInfo(String suitAccessToken, String authCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auth_code", authCode);
        String result = "";
        AuthCorpInfoVo corpInfoVo = new AuthCorpInfoVo();
        try {
            result = HttpUtil.post((String)("https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=" + suitAccessToken), (String)JSON.toJSONString(map));
            logger.info("getAuthCorpInfo result : {}" + result);
            JSONObject corpAuthObject = JSONObject.parseObject((String)result);
            if (StringUtils.isNotBlank((CharSequence)corpAuthObject.getString("permanent_code"))) {
                corpInfoVo.setAccessToken(corpAuthObject.getString("access_token"));
                corpInfoVo.setPermanentCode(corpAuthObject.getString("permanent_code"));
                JSONObject corpInfoObject = corpAuthObject.getJSONObject("auth_corp_info");
                corpInfoVo.setAuthCorpId(corpInfoObject.getString("corpid"));
                corpInfoVo.setAuthCorpName(corpInfoObject.getString("corp_name"));
                corpInfoVo.setAuthCorpFullName(corpInfoObject.getString("corp_full_name"));
                corpInfoVo.setAuthCorpLogoUrl(corpInfoObject.getString("corp_square_logo_url"));
                corpInfoVo.setLocation(corpInfoObject.getString("location"));
            }
        }
        catch (IOException e) {
            logger.error("getAuthCorpInfo error :" + e.getMessage());
        }
        return corpInfoVo;
    }

    public String getAuthCorpAccessToken(String suitAccessToken, String authCorpId, String permanentCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auth_corpid", authCorpId);
        map.put("permanent_code", permanentCode);
        String result = "";
        try {
            result = HttpUtil.post((String)("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=" + suitAccessToken), (String)JSON.toJSONString(map));
            logger.info("getAuthCorpAccessToken result : {}" + result);
            JSONObject corpAuthObject = JSONObject.parseObject((String)result);
            if (StringUtils.isNotBlank((CharSequence)corpAuthObject.getString("access_token"))) {
                return corpAuthObject.getString("access_token");
            }
        }
        catch (IOException e) {
            logger.error("getAuthCorpAccessToken error :" + e.getMessage());
        }
        return "";
    }

    public ExternalContactInfoVo getExternalContactInfo(String accessToken, String externalUserId) {
        ExternalContactInfoVo externalContactInfoVo = new ExternalContactInfoVo();
        try {
            String result = HttpUtil.get((String)("https://qyapi.weixin.qq.com/cgi-bin/crm/get_external_contact?access_token=" + accessToken + "&external_userid=" + externalUserId));
            logger.info("getExternalContactInfo result : {}" + result);
            JSONObject externalContactInfoObject = JSONObject.parseObject((String)result);
            if ("ok".equalsIgnoreCase(externalContactInfoObject.getString("errmsg"))) {
                JSONObject externalContactObject = externalContactInfoObject.getJSONObject("external_contact");
                externalContactInfoVo.setExternalUserId(externalContactObject.getString("external_userid"));
                externalContactInfoVo.setExternalName(externalContactObject.getString("name"));
                externalContactInfoVo.setUnionId(externalContactObject.getString("unionid"));
                externalContactInfoVo.setGender(externalContactObject.getInteger("gender").intValue());
                externalContactInfoVo.setAvatar(externalContactObject.getString("avatar"));
                externalContactInfoVo.setType(externalContactObject.getInteger("type").intValue());
                externalContactInfoVo.setCorpName(externalContactObject.getString("corp_name"));
            }
        }
        catch (IOException e) {
            logger.error("getExternalContactInfo error :" + e.getMessage());
        }
        return externalContactInfoVo;
    }

    public ContactStuffInfoVo getContactStuffInfo(String accessToken, String userId) {
        ContactStuffInfoVo contactStuffInfoVo = new ContactStuffInfoVo();
        try {
            String result = HttpUtil.get((String)("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + accessToken + "&userid=" + userId));
            logger.info("getContactStuffInfo result : {}" + result);
            JSONObject contactStuffInfoObject = JSONObject.parseObject((String)result);
            if ("ok".equalsIgnoreCase(contactStuffInfoObject.getString("errmsg"))) {
                contactStuffInfoVo.setUserId(contactStuffInfoObject.getString("userid"));
                contactStuffInfoVo.setUserName(contactStuffInfoObject.getString("name"));
                contactStuffInfoVo.setGender(contactStuffInfoObject.getInteger("gender").intValue());
                contactStuffInfoVo.setAvatar(contactStuffInfoObject.getString("avatar"));
                contactStuffInfoVo.setMobile(contactStuffInfoObject.getString("mobile"));
                contactStuffInfoVo.setQrCode(contactStuffInfoObject.getString("qr_code"));
            }
        }
        catch (IOException e) {
            logger.error("getContactStuffInfo error :" + e.getMessage());
        }
        return contactStuffInfoVo;
    }

    public String getContactAccessToken(String corpId, String secret) {
        try {
            String result = HttpUtil.get((String)("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + corpId + "&corpsecret=" + secret));
            logger.info("getContactAccessToken result :" + JSON.toJSONString((Object)result));
            JSONObject contactTokenObject = JSONObject.parseObject((String)result);
            if ("ok".equalsIgnoreCase(contactTokenObject.getString("errmsg"))) {
                return contactTokenObject.getString("access_token");
            }
        }
        catch (IOException e) {
            logger.error("getContactAccessToken error :" + e.getMessage());
        }
        return "";
    }

    public String getAccessToken(String corpId, String secret) {
        try {
            String result = HttpUtil.get((String)("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + corpId + "&corpsecret=" + secret));
            logger.info("getAccessToken result :" + JSON.toJSONString((Object)result));
            JSONObject contactTokenObject = JSONObject.parseObject((String)result);
            if ("ok".equalsIgnoreCase(contactTokenObject.getString("errmsg"))) {
                return contactTokenObject.getString("access_token");
            }
        }
        catch (IOException e) {
            logger.error("getAccessToken error :" + e.getMessage());
        }
        return "";
    }

    public String getUseridByAccessToken(String bizvaneMallToken, String code) {
        try {
            String result = HttpUtil.get((String)("https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session?access_token=" + bizvaneMallToken + "&js_code=" + code + "&grant_type=authorization_code"));
            logger.info("getUseridByAccessToken result :" + JSON.toJSONString((Object)result));
            JSONObject contactTokenObject = JSONObject.parseObject((String)result);
            if ("ok".equalsIgnoreCase(contactTokenObject.getString("errmsg"))) {
                return contactTokenObject.getString("userid");
            }
        }
        catch (IOException e) {
            logger.error("getUseridByAccessToken error :" + e.getMessage());
        }
        return "";
    }

    public String informStaff(String accessToken, JSONObject jsonObject) {
        try {
            String result = HttpUtil.post((String)("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken), (String)JSON.toJSONString((Object)jsonObject));
            logger.info("informStaff result :" + JSON.toJSONString((Object)result));
        }
        catch (IOException e) {
            logger.error("informStaff error :" + e.getMessage());
        }
        return "";
    }

    public String deleteUser(String employeeToken, String userid) {
        String result = null;
        logger.info("\u5220\u9664\u4f01\u5fae\u8d26\u53f7\u4e0d\u5904\u7406\uff0c\u9ed8\u8ba4\u6210\u529f\uff1auserId: {}", (Object)userid);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)0);
        result = JacksonUtil.bean2Json((Object)jsonObject);
        return result;
    }

    public String externalContactTransfer(String contactToken, String accessToken, String externalUserid, String handoverUserid, String takeoverUserid) {
        String contactResult = null;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("external_userid", (Object)externalUserid);
            jsonObject.put("handover_userid", (Object)handoverUserid);
            jsonObject.put("takeover_userid", (Object)takeoverUserid);
            logger.info("externalContactTransfer request:{}", (Object)jsonObject.toJSONString());
            contactResult = HttpUtil.post((String)("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/transfer?access_token=" + accessToken), (String)jsonObject.toJSONString());
            logger.info("externalContactTransfer response:{}", (Object)contactResult);
        }
        catch (Exception e) {
            logger.info("externalContactTransfer exception:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        return contactResult;
    }

    public String applicationDecryptMsg(HttpServletRequest request, String postData, WxQyApplication wxQyApplication) {
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wxQyApplication.getToken(), wxQyApplication.getEncodingAeskey(), wxQyApplication.getCorpId());
            return wxcpt.DecryptMsg(msg_signature, timestamp, nonce, postData);
        }
        catch (AesException e) {
            logger.error("decryptMsg error :" + e.getMessage());
            return "";
        }
    }

    public String applicationValidateSignature(HttpServletRequest request, WxQyApplication wxQyApplication) {
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(wxQyApplication.getToken(), wxQyApplication.getEncodingAeskey(), wxQyApplication.getCorpId());
            return wxcpt.VerifyURL(msg_signature, timestamp, nonce, echostr);
        }
        catch (AesException e) {
            logger.error("validateSignature error :" + e.getMessage());
            return "";
        }
    }
}

