/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.wechat.callback.server.service.component;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtilWeChat<K, V> {
    @Autowired
    private RedisTemplate<K, V> redisTemplate;

    public void deleteFromRedis(K key) {
        this.redisTemplate.delete(key);
    }

    public <HK> Boolean hashCheckHxists(K hKey, HK field) {
        return this.redisTemplate.opsForHash().hasKey(hKey, field);
    }

    public <HK> V hashGet(K hKey, HK hashKey) {
        return (V)this.redisTemplate.opsForHash().get(hKey, hashKey);
    }

    public Map<K, V> hashGetAll(K key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    public <HK> Long hashIncrementLongOfHashMap(K hKey, HK hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment(hKey, hashKey, delta.longValue());
    }

    public <HK> Double hashIncrementDoubleOfHashMap(K hKey, HK hashKey, Double delta) {
        return this.redisTemplate.opsForHash().increment(hKey, hashKey, delta.doubleValue());
    }

    public <HK> void hashPushHashMap(K key, HK hashKey, V value) {
        this.redisTemplate.opsForHash().put(key, hashKey, value);
    }

    public Set<V> hashGetAllHashKey(K key) {
        return this.redisTemplate.opsForHash().keys(key);
    }

    public Long hashGetHashMapSize(K key) {
        return this.redisTemplate.opsForHash().size(key);
    }

    public List<V> hashGetHashAllValues(K key) {
        return this.redisTemplate.opsForHash().values(key);
    }

    public <HK> Long hashDeleteHashKey(K key, HK ... hashKeys) {
        return this.redisTemplate.opsForHash().delete(key, (Object[])hashKeys);
    }

    public void listLeftPushList(K key, V value) {
        this.redisTemplate.opsForList().leftPush(key, value);
    }

    public V listLeftPopList(K key) {
        return (V)this.redisTemplate.opsForList().leftPop(key);
    }

    public Long listSize(K key) {
        return this.redisTemplate.opsForList().size(key);
    }

    public List<V> listRangeList(K key, Long start, Long end) {
        return this.redisTemplate.opsForList().range(key, start.longValue(), end.longValue());
    }

    public Long listRemoveFromList(K key, long i, V value) {
        return this.redisTemplate.opsForList().remove(key, i, value);
    }

    public V listIndexFromList(K key, long index) {
        return (V)this.redisTemplate.opsForList().index(key, index);
    }

    public void listSetValueToList(K key, long index, V value) {
        this.redisTemplate.opsForList().set(key, index, value);
    }

    public void listTrimByRange(K key, Long start, Long end) {
        this.redisTemplate.opsForList().trim(key, start.longValue(), end.longValue());
    }

    public void listRightPushList(K key, V value) {
        this.redisTemplate.opsForList().rightPush(key, value);
    }

    public V listRightPopList(K key) {
        return (V)this.redisTemplate.opsForList().rightPop(key);
    }

    public Long setAddSetMap(K key, V ... values) {
        return this.redisTemplate.opsForSet().add(key, (Object[])values);
    }

    public Long setGetSizeForSetMap(K key) {
        return this.redisTemplate.opsForSet().size(key);
    }

    public Set<V> setGetMemberOfSetMap(K key) {
        return this.redisTemplate.opsForSet().members(key);
    }

    public Boolean setCheckIsMemberOfSet(K key, V o) {
        return this.redisTemplate.opsForSet().isMember(key, o);
    }

    public Integer stringAppendString(K key, String value) {
        return this.redisTemplate.opsForValue().append(key, value);
    }

    public V stringGetStringByKey(K key) {
        return (V)this.redisTemplate.opsForValue().get(key);
    }

    public String stringGetSubStringFromString(K key, long start, long end) {
        return this.redisTemplate.opsForValue().get(key, start, end);
    }

    public Long stringIncrementLongString(K key, Long delta) {
        return this.redisTemplate.opsForValue().increment(key, delta.longValue());
    }

    public Double stringIncrementDoubleString(K key, Double delta) {
        return this.redisTemplate.opsForValue().increment(key, delta.doubleValue());
    }

    public void stringSetString(K key, V value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    public V stringGetAndSet(K key, V value) {
        return (V)this.redisTemplate.opsForValue().getAndSet(key, value);
    }

    public void stringSetValueAndExpireTime(K key, V value, long timeout) {
        this.redisTemplate.opsForValue().set(key, value, timeout, TimeUnit.MILLISECONDS);
    }
}

