/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.client.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DateTools {
    public static String ymd = "yyyy-MM-dd";
    public static SimpleDateFormat sdf = new SimpleDateFormat(ymd);

    public List<String> getBetweenDates(Date start, Date end) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(sdf.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return result;
    }

    public Date getYesterdayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date time = calendar.getTime();
        return time;
    }

    public String[] getPreMonth(Integer monthNum) {
        String[] months = new String[monthNum.intValue()];
        Calendar cal = Calendar.getInstance();
        cal.set(2, cal.get(2));
        for (int i = 0; i < monthNum; ++i) {
            String year;
            String month = cal.get(2) + "";
            if (month.length() == 1) {
                month = "0" + month;
            }
            if ((year = cal.get(1) + "-" + month).substring(5).equals("00")) {
                Integer yearNum = Integer.parseInt(year.substring(0, 4)) - 1;
                year = yearNum + "-12";
            }
            months[monthNum.intValue() - 1 - i] = year;
            cal.set(2, cal.get(2) - 1);
        }
        return months;
    }

    public List<String> getPreDoubleTwtlveMonth() {
        String[] preTwentyFourMonth = this.getPreMonth(24);
        ArrayList<String> preTwentyFourMonthList = new ArrayList<String>();
        for (String timeString : preTwentyFourMonth) {
            preTwentyFourMonthList.add(timeString);
        }
        String[] preTwelveMonth = this.getPreMonth(12);
        ArrayList<String> preTwelveMonthList = new ArrayList<String>();
        for (String timeString : preTwelveMonth) {
            preTwelveMonthList.add(timeString);
        }
        preTwentyFourMonthList.removeAll(preTwelveMonthList);
        return preTwentyFourMonthList;
    }

    public List<String> getPreWeek(String index) {
        String yearWeek;
        String weekOfYearString;
        Date date;
        SimpleDateFormat format;
        String temp;
        int i;
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int weekOfYear = calendar.get(3);
        ArrayList<String> weekList = new ArrayList<String>();
        String weekString = "";
        for (i = 0; i < 12; ++i) {
            if (--weekOfYear == 0) {
                temp = --year + "-12-30";
                format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    date = format.parse(temp);
                    calendar.setFirstDayOfWeek(2);
                    calendar.setTime(date);
                    weekOfYear = calendar.get(3);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if ((weekOfYearString = weekOfYear + "").length() == 1) {
                weekOfYearString = "0" + weekOfYearString;
            }
            yearWeek = year + "-" + weekOfYearString;
            weekList.add(yearWeek);
        }
        if ("betweenTwelveAndTwentyFour".equals(index)) {
            weekList.clear();
            for (i = 0; i < 12; ++i) {
                if (--weekOfYear == 0) {
                    temp = --year + "-12-30";
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        date = format.parse(temp);
                        calendar.setFirstDayOfWeek(2);
                        calendar.setTime(date);
                        weekOfYear = calendar.get(3);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if ((weekOfYearString = weekOfYear + "").length() == 1) {
                    weekOfYearString = "0" + weekOfYearString;
                }
                yearWeek = year + "-" + weekOfYearString;
                weekList.add(yearWeek);
            }
            Collections.reverse(weekList);
            return weekList;
        }
        Collections.reverse(weekList);
        return weekList;
    }

    public Date getLastIndexDayWeek(int index) {
        Date lastSevenDay = DateTools.getSpecifiedDayBefore(new Date(), index);
        return DateTools.getLastDayOfWeek(lastSevenDay);
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, 2);
        date = c.getTime();
        return date;
    }

    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return c.getTime();
    }

    public static String getSpecifiedDayBeforeString(String sDate, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return format.format(c.getTime());
    }
}

