/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.server.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.daas.nros.client.model.bean.StoreBean;
import com.daas.nros.client.model.bean.StoreReqBean;
import com.daas.nros.client.model.dto.StoreDTO;
import com.daas.nros.client.model.entity.Store;
import com.daas.nros.mesaage.gateway.client.model.base.Pagination;
import com.daas.nros.mesaage.gateway.client.model.bean.ListResultBean;
import com.daas.nros.server.dao.StoreDao;
import com.daas.nros.server.dao.StoreGroupRelDao;
import com.daas.nros.server.dao.StorePrivilegeDao;
import com.daas.nros.server.service.api.IStoreService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class StoreService
extends ServiceImpl<StoreDao, Store>
implements IStoreService {
    private static final Logger log = LoggerFactory.getLogger(StoreService.class);
    @Autowired
    private StoreDao storeDao;
    @Autowired
    private StoreGroupRelDao iStoreGroupRelDao;
    @Autowired
    private StorePrivilegeDao iStorePrivilegeDao;

    @Override
    public ListResultBean<StoreBean> page(String searchValue, Long companyId, Long storeOnlineCode, String storeName, String brandName, String storeGroupName, Long storeCode, Long dictionaryCode, String bizArea, String detailedAddress, String distributorName, Integer pageNo, Boolean status, Integer hasCode, Integer pageSize) {
        ListResultBean listResultBean = new ListResultBean();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"gr.valid", (Object)1);
        wrapper.eq((Object)"b.valid", (Object)1);
        wrapper.eq((Object)"s.sys_company_id", (Object)companyId);
        if (StrUtil.isNotBlank((CharSequence)searchValue)) {
            wrapper.and(childWrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)childWrapper.like((Object)"b.brand_name", (Object)searchValue)).or()).like((Object)"s.store_name", (Object)searchValue)).or()).like((Object)"s.sys_store_online_code", (Object)searchValue)).or()).like((Object)"s.sys_store_offline_code", (Object)searchValue);
            });
        }
        wrapper.like(Objects.nonNull(storeOnlineCode), (Object)"s.sys_store_online_code", (Object)storeOnlineCode);
        wrapper.like(Objects.nonNull(storeCode), (Object)"s.sys_store_offline_code", (Object)storeCode);
        wrapper.like(StrUtil.isNotBlank((CharSequence)storeName), (Object)"s.store_name", (Object)storeName);
        wrapper.like(StrUtil.isNotBlank((CharSequence)brandName), (Object)"b.brand_name", (Object)brandName);
        wrapper.like(StrUtil.isNotBlank((CharSequence)storeGroupName), (Object)"g.store_group_name", (Object)storeGroupName);
        wrapper.eq(Objects.nonNull(dictionaryCode), (Object)"s.dictionary_code", (Object)dictionaryCode);
        wrapper.like(StrUtil.isNotBlank((CharSequence)bizArea), (Object)"biz_area", (Object)bizArea);
        wrapper.like(StrUtil.isNotBlank((CharSequence)distributorName), (Object)"s.distributor_name", (Object)distributorName);
        wrapper.eq(Objects.nonNull(status), (Object)"s.status", (Object)status);
        if (hasCode != null && hasCode == 1) {
            wrapper.isNull((Object)"s.store_orcode");
        } else if (hasCode != null && hasCode == 0) {
            wrapper.isNotNull((Object)"s.store_orcode");
        }
        IPage<Store> result = this.storeDao.page((Page<Store>)page, (QueryWrapper<Store>)wrapper);
        listResultBean.setResult(Lists.transform((List)result.getRecords(), (Function)new Function<Store, StoreBean>(){

            @Nullable
            public StoreBean apply(@Nullable Store store) {
                StoreBean bean = new StoreBean();
                BeanUtils.copyProperties((Object)store, (Object)bean);
                return bean;
            }
        }));
        Pagination pagination = new Pagination();
        pagination.setItemCount(Long.valueOf(result.getTotal()));
        pagination.setPageCount(Long.valueOf(result.getTotal() / result.getSize()));
        pagination.setPageNo(pageNo);
        pagination.setPageSize(pageSize);
        listResultBean.setPagination(pagination);
        return listResultBean;
    }

    @Override
    public StoreBean getStoreInfo(Long storeId) {
        Store store = (Store)this.storeDao.selectById(storeId);
        StoreBean result = new StoreBean();
        BeanUtils.copyProperties((Object)store, (Object)result);
        return result;
    }

    @Override
    public int updateStoreStatus(Long storeId, String storeCode, boolean status) {
        Store store;
        int snum;
        if (!status && (snum = this.storeDao.selectSysStoreStaffRelCountByCode(store = (Store)this.storeDao.selectById(storeId))) > 0) {
            log.info("storeId\u4e3a{}\u7684\u5e97\u94fa\u8fd8\u5b58\u5728\u5458\u5de5\uff0c\u4e0d\u5141\u8bb8\u5173\u5e97!", (Object)storeId);
            throw new RuntimeException("\u5e97\u94fa\u8fd8\u5b58\u5728\u5458\u5de5\uff0c\u4e0d\u5141\u8bb8\u5173\u5e97");
        }
        Store storeTemp = new Store();
        storeTemp.setStatus(Integer.valueOf(status ? 1 : 0));
        storeTemp.setSysStoreId(storeId);
        return this.storeDao.updateById(storeTemp);
    }

    @Override
    public int updateNearbyStoresState(String storeIds, Long companyId, Long brandId, boolean isDisplay) {
        log.info("changeNearbyStoresState ids:{}", (Object)storeIds);
        return 0;
    }

    @Override
    public List<String> getStore(List<StoreReqBean> storeList) {
        String sysCompanyId = storeList.get(0).getSysCompanyId();
        List<String> storeIds = storeList.stream().map(e -> e.getOfflineStoreId()).distinct().collect(Collectors.toList());
        log.info("getStore \u67e5\u8be2\u53bb\u91cd\u4ee5\u540e\u7684storeIds\u6709:{}\u6761", (Object)storeIds.size());
        return this.storeDao.selectIdsByStoreIds(Long.parseLong(sysCompanyId), storeIds);
    }

    @Override
    @Transactional
    public Integer batchSave(List<StoreReqBean> storeList) {
        List stores = storeList.stream().map(e -> {
            Store store = new Store();
            store.setSysCompanyId(Long.valueOf(Long.parseLong(e.getSysCompanyId())));
            store.setSlaveSysBrandId(e.getSlaveSysBrandId());
            store.setStoreName(e.getStoreName());
            store.setSysStoreOfflineCode(e.getOfflineStoreCode());
            store.setSysStoreOnlineCode(e.getSysStoreOnlineCode());
            store.setSysBrandId(StringUtils.isEmpty((Object)e.getSysBrandId()) ? null : Long.valueOf(Long.parseLong(e.getSysBrandId())));
            store.setDistributorName(e.getDistributorName());
            store.setStoreType(StringUtils.isEmpty((Object)e.getStoreType()) ? null : Integer.valueOf(Integer.parseInt(e.getStoreType())));
            store.setStatus(StringUtils.isEmpty((Object)e.getStatus()) ? null : Integer.valueOf(Integer.parseInt(e.getStatus())));
            store.setStoreImgs(e.getStoreImgs());
            store.setStoreId(e.getOfflineStoreId());
            store.setProvinceName(e.getProvinceName());
            store.setCityName(e.getCityName());
            store.setAreaName(e.getAreaName());
            store.setDetailedAddress(e.getDetailedAddress());
            store.setStoreOrcode(e.getStoreOrcode());
            store.setLat(e.getLat());
            store.setLng(e.getLng());
            store.setShopOwner(e.getShopOwner());
            store.setStoreSize(StringUtils.isEmpty((Object)e.getStoreSize()) ? null : Double.valueOf(Double.parseDouble(e.getStoreSize())));
            store.setDictionaryCode(e.getDictionaryCode());
            store.setIsDisplay(StringUtils.isEmpty((Object)e.getIsDisplay()) ? null : Integer.valueOf(Integer.parseInt(e.getIsDisplay())));
            store.setBizArea(e.getBizArea());
            store.setCreateUserId(StringUtils.isEmpty((Object)e.getCreateUserId()) ? null : Long.valueOf(Long.parseLong(e.getCreateUserId())));
            store.setCreateUserName(e.getCreateUserName());
            store.setModifiedUserId(StringUtils.isEmpty((Object)e.getModifiedUserId()) ? null : Long.valueOf(Long.parseLong(e.getModifiedUserId())));
            store.setModifiedUserName(e.getModifiedUserName());
            store.setCreateDate(new Date());
            store.setModifiedDate(new Date());
            store.setValid(Integer.valueOf(1));
            return store;
        }).collect(Collectors.toList());
        boolean b = this.saveBatch(stores);
        return b ? storeList.size() : 0;
    }

    @Override
    public ArrayList<StoreDTO> getStore(String sysCompanyId, String sysBrandId, String offlineStoreCode, String offlineStoreId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"sys_company_id", (Object)sysCompanyId);
        qw.eq((Object)"sys_brand_id", (Object)sysBrandId);
        qw.eq(!StringUtils.isEmpty((Object)offlineStoreCode), (Object)"sys_store_offline_code", (Object)offlineStoreCode);
        qw.eq(!StringUtils.isEmpty((Object)offlineStoreId), (Object)"store_id", (Object)offlineStoreId);
        List stores = this.storeDao.selectList((Wrapper)qw);
        ArrayList result = !CollectionUtils.isEmpty((Collection)stores) ? stores.stream().map(e -> StoreDTO.convertFor((Store)e)).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList();
        return result;
    }

    @Override
    public StoreDTO getstore(String sysCompanyId, String sysBrandId, String offlineStoreCode) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"sys_company_id", (Object)sysCompanyId);
        qw.eq((Object)"sys_brand_id", (Object)sysBrandId);
        qw.eq((Object)"sys_store_offline_code", (Object)offlineStoreCode);
        Store store = (Store)this.storeDao.selectOne((Wrapper)qw);
        StoreDTO storeDTO = null;
        if (store != null) {
            storeDTO = StoreDTO.convertFor((Store)store);
        }
        return storeDTO;
    }

    @Override
    public StoreDTO save(String storeName, String offlineStoreId, String sysCompanyId, String sysBrandId, String slaveSysBrandId, String distributorName, String storeType, String offlineStoreCode, String sysStoreOnlineCode, String status, String storeImgs, String provinceName, String cityName, String areaName, String detailedAddress, String storeOrcode, String isDisplay, String lng, String lat, String bizArea, String shopOwner, String storeSize, String dictionaryCode, String createUserId, String createUserName, String modifiedUserId, String modifiedUserName) {
        Store store = new Store();
        store.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId)));
        store.setSlaveSysBrandId(slaveSysBrandId);
        store.setStoreName(storeName);
        store.setSysStoreOfflineCode(offlineStoreCode);
        store.setSysStoreOnlineCode(sysStoreOnlineCode);
        store.setSysBrandId(StringUtils.isEmpty((Object)sysBrandId) ? null : Long.valueOf(Long.parseLong(sysBrandId)));
        store.setDistributorName(distributorName);
        store.setStoreType(StringUtils.isEmpty((Object)storeType) ? null : Integer.valueOf(Integer.parseInt(storeType)));
        store.setStatus(StringUtils.isEmpty((Object)status) ? null : Integer.valueOf(Integer.parseInt(status)));
        store.setStoreImgs(storeImgs);
        store.setStoreId(offlineStoreId);
        store.setProvinceName(provinceName);
        store.setCityName(cityName);
        store.setAreaName(areaName);
        store.setDetailedAddress(detailedAddress);
        store.setStoreOrcode(storeOrcode);
        store.setLat(lat);
        store.setLng(lng);
        store.setShopOwner(shopOwner);
        store.setStoreSize(StringUtils.isEmpty((Object)storeSize) ? null : Double.valueOf(Double.parseDouble(storeSize)));
        store.setDictionaryCode(dictionaryCode);
        store.setIsDisplay(StringUtils.isEmpty((Object)isDisplay) ? null : Integer.valueOf(Integer.parseInt(isDisplay)));
        store.setBizArea(bizArea);
        store.setCreateUserId(StringUtils.isEmpty((Object)createUserId) ? null : Long.valueOf(Long.parseLong(createUserId)));
        store.setCreateUserName(createUserName);
        store.setModifiedUserId(StringUtils.isEmpty((Object)modifiedUserId) ? null : Long.valueOf(Long.parseLong(modifiedUserId)));
        store.setModifiedUserName(modifiedUserName);
        store.setCreateDate(new Date());
        store.setModifiedDate(new Date());
        store.setValid(Integer.valueOf(1));
        log.info("\u63d2\u5165\u7684\u6570\u636e\u662f:{}", (Object)JSON.toJSONString((Object)store));
        this.storeDao.insert(store);
        StoreDTO storeDTO = StoreDTO.convertFor((Store)store);
        return storeDTO;
    }

    @Override
    public Integer deleteById(String sysStoreId) {
        Store store = new Store();
        store.setSysStoreId(Long.valueOf(Long.parseLong(sysStoreId)));
        store.setValid(Integer.valueOf(0));
        return this.storeDao.updateById(store);
    }

    @Override
    public StoreDTO update(String sysStoreId, String storeName, String sysBrandId, String distributorName, String storeType, String status, String bizArea, String modifiedUserId, String modifiedUserName) {
        Store store = new Store();
        store.setSysStoreId(Long.valueOf(Long.parseLong(sysStoreId)));
        store.setStoreName(storeName);
        store.setSysBrandId(StringUtils.isEmpty((Object)sysBrandId) ? null : Long.valueOf(Long.parseLong(sysBrandId)));
        store.setDistributorName(distributorName);
        store.setStoreType(StringUtils.isEmpty((Object)storeType) ? null : Integer.valueOf(Integer.parseInt(storeType)));
        store.setStatus(StringUtils.isEmpty((Object)status) ? null : Integer.valueOf(Integer.parseInt(status)));
        store.setBizArea(bizArea);
        store.setModifiedUserId(StringUtils.isEmpty((Object)modifiedUserId) ? null : Long.valueOf(Long.parseLong(modifiedUserId)));
        store.setModifiedUserName(modifiedUserName);
        store.setModifiedDate(new Date());
        store.setValid(Integer.valueOf(1));
        this.storeDao.updateById(store);
        StoreDTO storeDTO = StoreDTO.convertFor((Store)store);
        return storeDTO;
    }
}

