/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.daas.nros.client.model.bean.StaffReqBean;
import com.daas.nros.client.model.bean.StoreStaffBean;
import com.daas.nros.client.model.dto.StaffDTO;
import com.daas.nros.client.model.entity.Staff;
import com.daas.nros.server.dao.StaffDao;
import com.daas.nros.server.service.api.IStaffService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StaffService
extends ServiceImpl<StaffDao, Staff>
implements IStaffService {
    private static final Logger log = LoggerFactory.getLogger(StaffService.class);
    @Autowired
    private StaffDao staffDao;

    @Override
    public IPage<StoreStaffBean> page(String searchValue, Long companyId, Long storeId, String staffCode, String staffName, String sex, String phone, String storeName, String storeCode, Integer status, Integer hasStaffOrCode, String position, Integer pageNo, Integer pageSize) {
        IPage<StoreStaffBean> listResultBean = null;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = Wrappers.query();
        if (hasStaffOrCode != null && hasStaffOrCode == 1) {
            wrapper.isNotNull((Object)"sr.staff_orcode");
        } else if (hasStaffOrCode != null && hasStaffOrCode == 0) {
            wrapper.isNull((Object)"sr.staff_orcode");
        }
        if (StringUtils.isNotBlank((CharSequence)searchValue)) {
            wrapper.and(childWrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)childWrapper.like((Object)"sf.staff_code", (Object)searchValue)).or()).like((Object)"sf.staff_name", (Object)searchValue)).or()).like((Object)"sf.phone", (Object)searchValue);
            });
        }
        wrapper.like(StringUtils.isNotBlank((CharSequence)staffCode), (Object)"sf.staff_code", (Object)staffCode);
        wrapper.like(StringUtils.isNotBlank((CharSequence)staffName), (Object)"sf.staff_name", (Object)staffName);
        wrapper.eq(StringUtils.isNotBlank((CharSequence)sex), (Object)"sf.sex", (Object)sex);
        wrapper.like(StringUtils.isNotBlank((CharSequence)phone), (Object)"sf.phone", (Object)phone);
        wrapper.like(StringUtils.isNotBlank((CharSequence)storeName), (Object)"st.store_name", (Object)storeName);
        wrapper.eq(Objects.nonNull(storeId), (Object)"st.sys_store_id", (Object)storeId);
        wrapper.eq(Objects.nonNull(status), (Object)"sf.status", (Object)status);
        wrapper.eq(StringUtils.isNotBlank((CharSequence)storeCode), (Object)"st.sys_store_offline_code", (Object)storeCode);
        wrapper.eq(Objects.nonNull(companyId), (Object)"sf.sys_company_id", (Object)companyId);
        wrapper.like(StringUtils.isNotBlank((CharSequence)position), (Object)"sf.position", (Object)position);
        wrapper.eq((Object)"sf.valid", (Object)"1");
        wrapper.eq((Object)"st.valid", (Object)"1");
        IPage<Staff> result = this.staffDao.page((Page<Staff>)page, (QueryWrapper<Staff>)wrapper);
        listResultBean.setRecords(Lists.transform((List)result.getRecords(), (Function)new Function<Staff, StoreStaffBean>(){

            @Nullable
            public StoreStaffBean apply(@Nullable Staff staff) {
                StoreStaffBean bean = new StoreStaffBean();
                BeanUtils.copyProperties((Object)staff, (Object)bean);
                return bean;
            }
        }));
        return listResultBean;
    }

    @Override
    public StoreStaffBean getStaffInfo(Long staffId, Long companyId) {
        Staff staff = this.staffDao.getStaffByStaffId(staffId, companyId);
        StoreStaffBean bean = new StoreStaffBean();
        BeanUtils.copyProperties((Object)staff, (Object)bean);
        return bean;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer batchSave(List<StaffReqBean> staffList) {
        List staffs = staffList.stream().map(e -> {
            Staff staff = new Staff();
            staff.setSysCompanyId(Long.valueOf(Long.parseLong(e.getSysCompanyId())));
            staff.setStaffCode(e.getStaffCode());
            staff.setStaffName(e.getStaffName());
            staff.setStaffId(e.getStaffId());
            staff.setStatus(Integer.valueOf(Integer.parseInt(e.getStatus())));
            staff.setImgs(e.getImgs());
            staff.setPhone(e.getPhone());
            staff.setEmail(e.getEmail());
            staff.setSex(e.getSex());
            staff.setPosition(e.getPosition());
            staff.setCountryCode(e.getCountryCode());
            staff.setCreateDate(new Date());
            staff.setCreateUserId(StringUtils.isBlank((CharSequence)e.getCreateUserId()) ? null : Long.valueOf(Long.parseLong(e.getCreateUserId())));
            staff.setCreateUserName(e.getCreateUserName());
            staff.setModifiedDate(new Date());
            staff.setModifiedUserId(StringUtils.isBlank((CharSequence)e.getModifiedUserId()) ? null : Long.valueOf(Long.parseLong(e.getModifiedUserId())));
            staff.setModifiedUserName(e.getModifiedUserName());
            return staff;
        }).collect(Collectors.toList());
        boolean b = this.saveBatch(staffs);
        return b ? staffList.size() : 0;
    }

    @Override
    public ArrayList<StaffDTO> getStaff(String sysCompanyId, String staffCode, String staffId, String phone) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"sys_company_id", (Object)sysCompanyId);
        query.eq(!StringUtils.isBlank((CharSequence)staffCode), (Object)"staff_code", (Object)staffCode);
        query.eq(!StringUtils.isBlank((CharSequence)staffId), (Object)"staff_id", (Object)staffId);
        query.eq(!StringUtils.isBlank((CharSequence)phone), (Object)"phone", (Object)phone);
        query.eq((Object)"valid", (Object)1);
        List staffs = this.staffDao.selectList((Wrapper)query);
        ArrayList result = CollectionUtils.isEmpty((Collection)staffs) ? new ArrayList() : staffs.stream().map(e -> StaffDTO.convertFor((Staff)e)).collect(Collectors.toCollection(ArrayList::new));
        return result;
    }

    @Override
    public Integer delete(String sysStaffId) {
        Staff staff = new Staff();
        staff.setSysStaffId(Long.valueOf(Long.parseLong(sysStaffId)));
        staff.setValid(Integer.valueOf(0));
        return this.staffDao.updateById(staff);
    }

    @Override
    public StaffDTO update(String sysStaffId, String staffName, String staffId, String imgs, String phone, String email, String sex, String position, String countryCode, String modifiedUserId, String modifiedUserName) {
        Staff staff = new Staff();
        staff.setSysStaffId(Long.valueOf(Long.parseLong(sysStaffId)));
        staff.setStaffName(staffName);
        staff.setStaffId(staffId);
        staff.setImgs(imgs);
        staff.setPhone(phone);
        staff.setEmail(email);
        staff.setSex(sex);
        staff.setPosition(position);
        staff.setCountryCode(countryCode);
        staff.setCreateDate(new Date());
        staff.setModifiedDate(new Date());
        staff.setModifiedUserId(StringUtils.isBlank((CharSequence)modifiedUserId) ? null : Long.valueOf(Long.parseLong(modifiedUserId)));
        staff.setModifiedUserName(modifiedUserName);
        this.staffDao.updateById(staff);
        return StaffDTO.convertFor((Staff)staff);
    }

    @Override
    public StaffDTO save(String sysCompanyId, String staffCode, String staffName, String staffId, String status, String imgs, String phone, String email, String sex, String position, String countryCode, String createUserId, String createUserName, String modifiedUserId, String modifiedUserName) {
        Staff staff = new Staff();
        staff.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId)));
        staff.setStaffCode(staffCode);
        staff.setStaffName(staffName);
        staff.setStaffId(staffId);
        staff.setStatus(Integer.valueOf(Integer.parseInt(status)));
        staff.setImgs(imgs);
        staff.setPhone(phone);
        staff.setEmail(email);
        staff.setSex(sex);
        staff.setPosition(position);
        staff.setCountryCode(countryCode);
        staff.setCreateDate(new Date());
        staff.setCreateUserId(StringUtils.isBlank((CharSequence)createUserId) ? null : Long.valueOf(Long.parseLong(createUserId)));
        staff.setCreateUserName(createUserName);
        staff.setModifiedDate(new Date());
        staff.setModifiedUserId(StringUtils.isBlank((CharSequence)modifiedUserId) ? null : Long.valueOf(Long.parseLong(modifiedUserId)));
        staff.setModifiedUserName(modifiedUserName);
        this.staffDao.insert(staff);
        return StaffDTO.convertFor((Staff)staff);
    }
}

