/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.oss.server.service.component;

import com.alibaba.fastjson.JSON;
import com.daas.nros.oss.client.enums.ExceptionEnum;
import com.daas.nros.oss.client.enums.exception.OssServiceException;
import com.daas.nros.oss.client.model.bean.Account;
import com.daas.nros.oss.server.service.component.BaseComponent;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QiniuComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(QiniuComponent.class);

    @Override
    protected String doUploadFile(Account account, byte[] byteArrays, String fileName) throws OssServiceException {
        Configuration cfg = new Configuration(Region.huadong());
        UploadManager uploadManager = new UploadManager(cfg);
        try {
            Auth auth = Auth.create((String)account.getAccessKey(), (String)account.getSecretKey());
            String upToken = auth.uploadToken(account.getBucketNm());
            Response response = uploadManager.put(byteArrays, fileName, upToken);
            DefaultPutRet putRet = (DefaultPutRet)JSON.parseObject((String)response.bodyString(), DefaultPutRet.class);
            return account.getDomain() + putRet.key;
        }
        catch (Exception e) {
            log.error("\u4e03\u725b\u5f02\u5e38: msg:{} ,e:{}", (Object)e.getMessage(), (Object)e);
            throw OssServiceException.newBuilder().errCode(ExceptionEnum.QINIU_OSS_SERVICE_ERROR.getErrCode()).errCodeDes(ExceptionEnum.QINIU_OSS_SERVICE_ERROR.getErrCodeDes()).build();
        }
    }

    @Override
    protected String doGetPicSelfDef(String format, String picUrl, String heigh, String weight) {
        StringBuilder sb = new StringBuilder(picUrl);
        StringBuilder pickNewUrl = sb.append("?imageView2/1").append("/w/").append(weight).append("/h/").append(heigh).append("/format/").append(format).append("/interlace/1").append("/ignore-error/1");
        log.info("\u5904\u7406\u5b8c\u6210\u7684\u56fe\u7247\u5730\u5740\u662f:{}", (Object)pickNewUrl.toString());
        return pickNewUrl.toString();
    }
}

