/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.oss.server.service.component;

import com.daas.nros.oss.client.enums.AccountStrategyEnum;
import com.daas.nros.oss.client.enums.ExceptionEnum;
import com.daas.nros.oss.client.enums.exception.OssServiceException;
import com.daas.nros.oss.client.model.bean.Account;
import com.daas.nros.oss.client.model.bean.AccountCacheBean;
import com.daas.nros.oss.server.config.AccountCachePostConstructComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(BaseComponent.class);
    private static final String OSS_ACCOUNT_KEY_SUFIX = "baseservice-oss::";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public String uploadFile(String accountName, byte[] byteArrays, String fileName) throws OssServiceException {
        return this.doUploadFile(this.createAccount(accountName), byteArrays, fileName);
    }

    public String getPic400X400(String format, String picUrl) throws OssServiceException {
        return this.getPicSelfDef(format, picUrl, "400", "400");
    }

    public String getPic800X800(String format, String picUrl) throws OssServiceException {
        return this.getPicSelfDef(format, picUrl, "800", "800");
    }

    public String getPicSelfDef(String format, String picUrl, String heigh, String weight) throws OssServiceException {
        if (!AccountStrategyEnum.checkUrl((String)picUrl)) {
            throw OssServiceException.newBuilder().errCode(ExceptionEnum.PIC_URL_ILLEGAL.getErrCode()).errCodeDes(ExceptionEnum.PIC_URL_ILLEGAL.getErrCodeDes()).build();
        }
        return this.doGetPicSelfDef(format, picUrl, heigh, weight);
    }

    private Account createAccount(String accountName) throws OssServiceException {
        AccountCacheBean cacheBean = AccountCachePostConstructComponent.getInstance(accountName);
        if (cacheBean == null) {
            throw OssServiceException.newBuilder().errCode(ExceptionEnum.ACCOUNT_NOT_EXIST.getErrCode()).errCodeDes(ExceptionEnum.ACCOUNT_NOT_EXIST.getErrCodeDes()).build();
        }
        Account account = new Account();
        BeanUtils.copyProperties((Object)cacheBean, (Object)account);
        return account;
    }

    protected abstract String doUploadFile(Account var1, byte[] var2, String var3) throws OssServiceException;

    protected abstract String doGetPicSelfDef(String var1, String var2, String var3, String var4);
}

