/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.oss.server.service.component;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSS;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.daas.nros.oss.client.enums.ExceptionEnum;
import com.daas.nros.oss.client.enums.exception.OssServiceException;
import com.daas.nros.oss.client.model.bean.Account;
import com.daas.nros.oss.client.utils.AccountUtil;
import com.daas.nros.oss.server.service.component.BaseComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(AliComponent.class);

    @Override
    protected String doUploadFile(Account account, byte[] byteArrays, String fileName) throws OssServiceException {
        OSS client = AccountUtil.getClient((Account)account);
        ByteArrayInputStream inputStream = null;
        try {
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            if ("jpg".equals(fileType) || "jpeg".equals(fileType)) {
                fileType = "image/jpg";
            }
            if ("png".equals(fileType)) {
                fileType = "image/png";
            }
            ObjectMetadata omd = new ObjectMetadata();
            omd.setContentDisposition("inline;");
            omd.setContentType(fileType);
            PutObjectResult res = client.putObject(account.getBucketNm(), fileName, (InputStream)new ByteArrayInputStream(byteArrays), omd);
            log.info("\u4e0a\u4f20\u6587\u4ef6aliyun-oss\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)res));
            String string = account.getDomain() + "/" + fileName;
            return string;
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91oss\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38 msg:{} e:{}", (Object)e.getMessage(), (Object)e);
            throw OssServiceException.newBuilder().errCode(ExceptionEnum.ALIYUN_OSS_SERVICE_ERROR.getErrCode()).errCodeDes(ExceptionEnum.ALIYUN_OSS_SERVICE_ERROR.getErrCodeDes()).build();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("close inputStream error:{}", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String doGetPicSelfDef(String format, String picUrl, String heigh, String weight) {
        StringBuilder sb = new StringBuilder(picUrl);
        StringBuilder append = sb.append("?x-oss-process=image/").append("format,").append(format).append("/resize,l_").append(weight).append(",h_").append(heigh);
        return append.toString();
    }
}

