/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.oss.server.config;

import com.alibaba.fastjson.JSON;
import com.daas.nros.oss.client.model.bean.AccountCacheBean;
import com.daas.nros.oss.server.config.AccountProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AccountCachePostConstructComponent {
    private static final Logger log = LoggerFactory.getLogger(AccountCachePostConstructComponent.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final String OSS_ACCOUNT_KEY_SUFIX = "baseservice-oss::";
    @Autowired
    private AccountProperties accountProperties;
    private static volatile Map<String, AccountCacheBean> instances = new HashMap<String, AccountCacheBean>();

    public static AccountCacheBean getInstance(String name) {
        AccountCacheBean service = instances.get(name);
        if (service == null) {
            // empty if block
        }
        return service;
    }

    @PostConstruct
    public void saveAccount() {
        List<AccountCacheBean> list = this.accountProperties.getList();
        log.info("oss \u57fa\u672c\u914d\u7f6e:{}", (Object)JSON.toJSONString(list));
        if (!CollectionUtils.isEmpty(list)) {
            for (AccountCacheBean e : list) {
                String key = OSS_ACCOUNT_KEY_SUFIX + e.getName();
                this.redisTemplate.opsForValue().set((Object)key, (Object)e);
                instances.put(e.getName(), e);
                log.info("\u4fdd\u5b58oss accountName:{}", (Object)e.getName());
            }
        } else {
            log.error("oss\u57fa\u672c\u914d\u7f6e\u662f\u7a7a\uff0c\u8bf7\u68c0\u67e5nacos\u914d\u7f6e");
        }
    }
}

