/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.oss.start.controller;

import cn.hutool.core.codec.Base64Decoder;
import com.bizvane.baseservice.oss.bean.ErrorInfo;
import com.bizvane.baseservice.oss.bean.ResultBean;
import com.bizvane.baseservice.oss.dto.OssUploadReqDto;
import com.daas.nros.oss.client.enums.AccountStrategyEnum;
import com.daas.nros.oss.client.enums.ExceptionEnum;
import com.daas.nros.oss.client.enums.exception.OssServiceException;
import com.daas.nros.oss.server.service.component.BaseComponent;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"oss"})
public class OssController {
    private static final Logger log = LoggerFactory.getLogger(OssController.class);
    @Autowired
    private Map<String, BaseComponent> map;

    @RequestMapping(value={"uploadFileByBase64"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultBean<String> uploadFileByBase64(@RequestBody @Validated OssUploadReqDto ossUploadReqDto) {
        ResultBean result = new ResultBean();
        if (!AccountStrategyEnum.containsAccountName((String)ossUploadReqDto.getAccountName())) {
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCode(), ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        BaseComponent baseComponent = this.map.get(AccountStrategyEnum.getStrategy((String)ossUploadReqDto.getAccountName()));
        try {
            byte[] decode = Base64Decoder.decode((CharSequence)ossUploadReqDto.getBase64Content());
            log.info("\u5f53\u524d\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f:{},\u6587\u4ef6\u540d:{},\u8d26\u6237:{}", new Object[]{decode.length, ossUploadReqDto.getFileName(), ossUploadReqDto.getAccountName()});
            String picUrl = baseComponent.uploadFile(ossUploadReqDto.getAccountName(), decode, ossUploadReqDto.getFileName());
            result.setSuccess(Boolean.valueOf(true));
            result.setResult((Serializable)((Object)picUrl));
            System.out.println(picUrl);
        }
        catch (OssServiceException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: msg:{}, e:{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }

    @RequestMapping(value={"uploadFile"}, produces={"application/json"})
    public ResultBean<String> uploadFile(MultipartFile file, @RequestParam(value="fileName") String fileName, @RequestParam(value="accountName") String accountName) {
        ResultBean result = new ResultBean();
        if (!AccountStrategyEnum.containsAccountName((String)accountName)) {
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCode(), ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        BaseComponent baseComponent = this.map.get(AccountStrategyEnum.getStrategy((String)accountName));
        try {
            byte[] bytes = file.getBytes();
            log.info("\u5f53\u524d\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f:{}", (Object)bytes.length);
            String picUrl = baseComponent.uploadFile(accountName, bytes, fileName);
            result.setSuccess(Boolean.valueOf(true));
            result.setResult((Serializable)((Object)picUrl));
            System.out.println(picUrl);
        }
        catch (OssServiceException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: msg:{}, e:{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
        }
        catch (Exception e) {
            result.setErrorInfo(new ErrorInfo("6000", "oss\u670d\u52a1\u5f02\u5e38"));
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }

    @RequestMapping(value={"getPic400X400"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultBean<String> getPic400X400(@RequestParam(value="accountName") String accountName, @RequestParam(value="picUrl") String picUrl, @RequestParam(value="format") String format) {
        ResultBean result = new ResultBean();
        if (!AccountStrategyEnum.containsAccountName((String)accountName)) {
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCode(), ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        BaseComponent baseComponent = this.map.get(AccountStrategyEnum.getStrategy((String)accountName));
        try {
            String newPicUrl = baseComponent.getPic400X400(format, picUrl);
            result.setSuccess(Boolean.valueOf(true));
            result.setResult((Serializable)((Object)newPicUrl));
        }
        catch (OssServiceException e) {
            log.error("\u83b7\u53d6400X400\u56fe\u7247\u5730\u5740\u5f02\u5e38: msg:{}, e:{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }

    @RequestMapping(value={"getPic800X800"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultBean<String> getPic800X800(@RequestParam(value="accountName") String accountName, @RequestParam(value="picUrl") String picUrl, @RequestParam(value="format") String format) {
        ResultBean result = new ResultBean();
        if (!AccountStrategyEnum.containsAccountName((String)accountName)) {
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCode(), ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        BaseComponent baseComponent = this.map.get(AccountStrategyEnum.getStrategy((String)accountName));
        try {
            String newPicUrl = baseComponent.getPic800X800(format, picUrl);
            result.setSuccess(Boolean.valueOf(true));
            result.setResult((Serializable)((Object)newPicUrl));
        }
        catch (OssServiceException e) {
            log.error("\u83b7\u53d6800X800\u56fe\u7247\u5730\u5740\u5f02\u5e38: msg:{}, e:{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }

    @RequestMapping(value={"getPicSelfDef"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultBean<String> getPicSelfDef(@RequestParam(value="accountName") String accountName, @RequestParam(value="picUrl") String picUrl, @RequestParam(value="format") String format, @RequestParam(value="heigh") String heigh, @RequestParam(value="weight") String weight) {
        ResultBean result = new ResultBean();
        if (!AccountStrategyEnum.containsAccountName((String)accountName)) {
            result.setErrorInfo(new ErrorInfo(ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCode(), ExceptionEnum.ACCOUNT_NAME_NOT_EXIST_ERROR.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        BaseComponent baseComponent = this.map.get(AccountStrategyEnum.getStrategy((String)accountName));
        try {
            String newPicUrl = baseComponent.getPicSelfDef(format, picUrl, heigh, weight);
            result.setSuccess(Boolean.valueOf(true));
            result.setResult((Serializable)((Object)newPicUrl));
        }
        catch (OssServiceException e) {
            log.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u7247\u5730\u5740\u5f02\u5e38: msg:{}, e:{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }
}

