/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisDefaultParameterHandler;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ParameterUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    protected static final Log logger = LogFactory.getLog(PaginationInterceptor.class);
    protected ISqlParser countSqlParser;
    protected boolean overflow = false;
    protected long limit = 500L;
    private DbType dbType;
    private IDialect dialect;
    @Deprecated
    protected String dialectType;
    @Deprecated
    protected String dialectClazz;

    public String concatOrderBy(String originalSql, IPage<?> page) {
        if (CollectionUtils.isNotEmpty((Collection)page.orders())) {
            try {
                List orderList = page.orders();
                Select selectStatement = (Select)CCJSqlParserUtil.parse((String)originalSql);
                if (selectStatement.getSelectBody() instanceof PlainSelect) {
                    PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
                    List orderByElements = plainSelect.getOrderByElements();
                    List<OrderByElement> orderByElementsReturn = PaginationInterceptor.addOrderByElements(orderList, orderByElements);
                    plainSelect.setOrderByElements(orderByElementsReturn);
                    return plainSelect.toString();
                }
                if (selectStatement.getSelectBody() instanceof SetOperationList) {
                    SetOperationList setOperationList = (SetOperationList)selectStatement.getSelectBody();
                    List orderByElements = setOperationList.getOrderByElements();
                    List<OrderByElement> orderByElementsReturn = PaginationInterceptor.addOrderByElements(orderList, orderByElements);
                    setOperationList.setOrderByElements(orderByElementsReturn);
                    return setOperationList.toString();
                }
                if (selectStatement.getSelectBody() instanceof WithItem) {
                    return originalSql;
                }
                return originalSql;
            }
            catch (JSQLParserException e) {
                logger.warn("failed to concat orderBy from IPage, exception=" + e.getMessage());
            }
        }
        return originalSql;
    }

    private static List<OrderByElement> addOrderByElements(List<OrderItem> orderList, List<OrderByElement> orderByElements) {
        orderByElements = CollectionUtils.isEmpty(orderByElements) ? new ArrayList<OrderByElement>(orderList.size()) : orderByElements;
        List orderByElementList = orderList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getColumn())).map(item -> {
            OrderByElement element = new OrderByElement();
            element.setExpression((Expression)new Column(item.getColumn()));
            element.setAsc(item.isAsc());
            element.setAscDescPresent(true);
            return element;
        }).collect(Collectors.toList());
        orderByElements.addAll(orderByElementList);
        return orderByElements;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT != mappedStatement.getSqlCommandType() || StatementType.CALLABLE == mappedStatement.getStatementType()) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object paramObj = boundSql.getParameterObject();
        IPage page = ParameterUtils.findPage((Object)paramObj).orElse(null);
        if (null == page || page.getSize() < 0L) {
            return invocation.proceed();
        }
        if (this.limit > 0L && this.limit <= page.getSize()) {
            this.handlerLimit(page);
        }
        String originalSql = boundSql.getSql();
        Connection connection = (Connection)invocation.getArgs()[0];
        if (page.isSearchCount() && !page.isHitCount()) {
            SqlInfo sqlInfo = SqlParserUtils.getOptimizeCountSql(page.optimizeCountSql(), this.countSqlParser, originalSql);
            this.queryTotal(sqlInfo.getSql(), mappedStatement, boundSql, page, connection);
            if (page.getTotal() <= 0L) {
                return null;
            }
        }
        DbType dbType = this.dbType == null ? JdbcUtils.getDbType(connection.getMetaData().getURL()) : this.dbType;
        IDialect dialect = Optional.ofNullable(this.dialect).orElseGet(() -> DialectFactory.getDialect(dbType));
        String buildSql = this.concatOrderBy(originalSql, page);
        DialectModel model = dialect.buildPaginationSql(buildSql, page.offset(), page.getSize());
        Configuration configuration = mappedStatement.getConfiguration();
        ArrayList<ParameterMapping> mappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
        Map additionalParameters = (Map)metaObject.getValue("delegate.boundSql.additionalParameters");
        model.consumers(mappings, configuration, additionalParameters);
        metaObject.setValue("delegate.boundSql.sql", (Object)model.getDialectSql());
        metaObject.setValue("delegate.boundSql.parameterMappings", mappings);
        return invocation.proceed();
    }

    protected void handlerLimit(IPage<?> page) {
        page.setSize(this.limit);
    }

    protected void queryTotal(String sql, MappedStatement mappedStatement, BoundSql boundSql, IPage<?> page, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            MybatisDefaultParameterHandler parameterHandler = new MybatisDefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
            parameterHandler.setParameters(statement);
            long total = 0L;
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    total = resultSet.getLong(1);
                }
            }
            page.setTotal(total);
            if (this.overflow && page.getCurrent() > page.getPages()) {
                this.handlerOverflow(page);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)"Error: Method queryTotal execution error of sql : \n %s \n", (Throwable)e, (Object[])new Object[]{sql});
        }
    }

    protected void handlerOverflow(IPage<?> page) {
        page.setCurrent(1L);
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String countSqlParser = prop.getProperty("countSqlParser");
        String overflow = prop.getProperty("overflow");
        String limit = prop.getProperty("limit");
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        this.setOverflow(Boolean.parseBoolean(overflow));
        if (StringUtils.isNotBlank((CharSequence)countSqlParser)) {
            this.setCountSqlParser((ISqlParser)ClassUtils.newInstance((String)countSqlParser));
        }
        if (StringUtils.isNotBlank((CharSequence)dialectType)) {
            this.setDialectType(dialectType);
        }
        if (StringUtils.isNotBlank((CharSequence)dialectClazz)) {
            this.setDialectClazz(dialectClazz);
        }
        if (StringUtils.isNotBlank((CharSequence)limit)) {
            this.setLimit(Long.parseLong(limit));
        }
    }

    @Deprecated
    public void setDialectType(String dialectType) {
        this.setDbType(DbType.getDbType((String)dialectType));
    }

    @Deprecated
    public void setDialectClazz(String dialectClazz) {
        this.setDialect(DialectFactory.getDialect(dialectClazz));
    }

    public PaginationInterceptor setCountSqlParser(ISqlParser countSqlParser) {
        this.countSqlParser = countSqlParser;
        return this;
    }

    public PaginationInterceptor setOverflow(boolean overflow) {
        this.overflow = overflow;
        return this;
    }

    public PaginationInterceptor setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public PaginationInterceptor setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public PaginationInterceptor setDialect(IDialect dialect) {
        this.dialect = dialect;
        return this;
    }
}

