/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.parsers;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.parsers.ITableNameHandler;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;

public class DynamicTableNameParser
implements ISqlParser {
    private Map<String, ITableNameHandler> tableNameHandlerMap;

    public SqlInfo parser(MetaObject metaObject, String sql) {
        Collection tables;
        Assert.isFalse((boolean)CollectionUtils.isEmpty(this.tableNameHandlerMap), (String)"tableNameHandlerMap is empty.", (Object[])new Object[0]);
        if (this.allowProcess(metaObject) && CollectionUtils.isNotEmpty((Collection)(tables = new TableNameParser(sql).tables()))) {
            boolean sqlParsed = false;
            String parsedSql = sql;
            for (String table : tables) {
                ITableNameHandler tableNameHandler = this.tableNameHandlerMap.get(table);
                if (null == tableNameHandler) continue;
                parsedSql = tableNameHandler.process(metaObject, parsedSql, table);
                sqlParsed = true;
            }
            if (sqlParsed) {
                return SqlInfo.newInstance().setSql(parsedSql);
            }
        }
        return null;
    }

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public Map<String, ITableNameHandler> getTableNameHandlerMap() {
        return this.tableNameHandlerMap;
    }

    public DynamicTableNameParser setTableNameHandlerMap(Map<String, ITableNameHandler> tableNameHandlerMap) {
        this.tableNameHandlerMap = tableNameHandlerMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableNameParser)) {
            return false;
        }
        DynamicTableNameParser other = (DynamicTableNameParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ITableNameHandler> this$tableNameHandlerMap = this.getTableNameHandlerMap();
        Map<String, ITableNameHandler> other$tableNameHandlerMap = other.getTableNameHandlerMap();
        return !(this$tableNameHandlerMap == null ? other$tableNameHandlerMap != null : !((Object)this$tableNameHandlerMap).equals(other$tableNameHandlerMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableNameParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ITableNameHandler> $tableNameHandlerMap = this.getTableNameHandlerMap();
        result = result * 59 + ($tableNameHandlerMap == null ? 43 : ((Object)$tableNameHandlerMap).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicTableNameParser(tableNameHandlerMap=" + this.getTableNameHandlerMap() + ")";
    }
}

