/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.utils.Bytes;
import com.aliyun.openservices.ots.utils.CalculateHelper;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.Arrays;

public class PrimaryKeyValue
implements Comparable<PrimaryKeyValue> {
    public static final PrimaryKeyValue INF_MAX = new PrimaryKeyValue("INF_MAX", null);
    public static final PrimaryKeyValue INF_MIN = new PrimaryKeyValue("INF_MIN", null);
    private Object value;
    private PrimaryKeyType type;
    private int dataSize = 0;

    PrimaryKeyValue(Object value, PrimaryKeyType type) {
        this.value = value;
        this.type = type;
        if (this.type != null) {
            switch (this.type) {
                case INTEGER: {
                    this.dataSize = 8;
                    break;
                }
                case STRING: {
                    this.dataSize = CalculateHelper.getStringDataSize(this.asString());
                    break;
                }
                case BINARY: {
                    this.dataSize = this.asBinary().length;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)type));
                }
            }
        }
    }

    public PrimaryKeyType getType() {
        return this.type;
    }

    public int getSize() {
        return this.dataSize;
    }

    public static PrimaryKeyValue fromString(String value) {
        CodingUtils.assertParameterNotNull(value, "value");
        return new PrimaryKeyValue(value, PrimaryKeyType.STRING);
    }

    public static PrimaryKeyValue fromLong(long value) {
        return new PrimaryKeyValue(value, PrimaryKeyType.INTEGER);
    }

    public String asString() {
        if (this.type != PrimaryKeyType.STRING) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "STRING"));
        }
        return (String)this.value;
    }

    public long asLong() {
        if (this.type != PrimaryKeyType.INTEGER) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "INTEGER"));
        }
        return (Long)this.value;
    }

    public static PrimaryKeyValue fromBinary(byte[] value) {
        return new PrimaryKeyValue(value, PrimaryKeyType.BINARY);
    }

    public byte[] asBinary() {
        if (this.type != PrimaryKeyType.BINARY) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BINARY"));
        }
        return (byte[])this.value;
    }

    public boolean isInfMin() {
        return this.type == null && this.value.equals("INF_MIN");
    }

    public boolean isInfMax() {
        return this.type == null && this.value.equals("INF_MAX");
    }

    public static PrimaryKeyValue fromColumn(ColumnValue value) {
        switch (value.getType()) {
            case STRING: {
                return PrimaryKeyValue.fromString(value.asString());
            }
            case INTEGER: {
                return PrimaryKeyValue.fromLong(value.asLong());
            }
            case BINARY: {
                return PrimaryKeyValue.fromBinary(value.asBinary());
            }
        }
        throw new IllegalArgumentException("Can not convert from column with not compatible type: " + (Object)((Object)value.getType()));
    }

    public int hashCode() {
        if (this.type == PrimaryKeyType.BINARY) {
            return Arrays.hashCode(this.asBinary()) * 31 + this.type.hashCode();
        }
        return this.value.hashCode() * 31 + this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeyValue)) {
            return false;
        }
        PrimaryKeyValue val = (PrimaryKeyValue)o;
        if (this.isInfMin()) {
            return val.isInfMin();
        }
        if (this.isInfMax()) {
            return val.isInfMax();
        }
        if (this.type == val.type) {
            if (this.type == PrimaryKeyType.BINARY) {
                return Bytes.equals((byte[])this.value, (byte[])val.value);
            }
            return this.value.equals(val.value);
        }
        return false;
    }

    public String toString() {
        if (this.type == PrimaryKeyType.BINARY) {
            return Arrays.toString(this.asBinary()) + ":" + (Object)((Object)this.type);
        }
        return this.value.toString() + ":" + (Object)((Object)this.type);
    }

    @Override
    public int compareTo(PrimaryKeyValue target) {
        if (this.type == null) {
            if (target.type == null && target.value.equals(this.value)) {
                return 0;
            }
            if (this.value.equals("INF_MIN")) {
                return -1;
            }
            return 1;
        }
        if (target.type == null) {
            if (target.value.equals("INF_MIN")) {
                return 1;
            }
            return -1;
        }
        if (this.type != target.type) {
            throw new IllegalArgumentException("The type of primary key to compare must be the same.");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareTo(target.asString());
            }
            case INTEGER: {
                return ((Long)this.value).compareTo(target.asLong());
            }
            case BINARY: {
                byte[] b1 = (byte[])this.value;
                byte[] b2 = (byte[])target.value;
                int ret = Bytes.compareByteArrayInLexOrder(b1, 0, b1.length, b2, 0, b2.length);
                return ret;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
    }
}

