/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.utils.Bytes;
import com.aliyun.openservices.ots.utils.CalculateHelper;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.Arrays;

public class ColumnValue
implements Comparable<ColumnValue> {
    private ColumnType type;
    private Object value;
    private int dataSize = 0;

    private ColumnValue(Object value, ColumnType type) {
        CodingUtils.assertParameterNotNull(value, "value");
        CodingUtils.assertParameterNotNull((Object)type, "type");
        this.value = value;
        this.type = type;
        switch (this.type) {
            case INTEGER: {
                this.dataSize = 8;
                break;
            }
            case STRING: {
                this.dataSize = CalculateHelper.getStringDataSize(this.asString());
                break;
            }
            case BINARY: {
                this.dataSize = this.asBinary().length;
                break;
            }
            case DOUBLE: {
                this.dataSize = 8;
                break;
            }
            case BOOLEAN: {
                this.dataSize = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)type));
            }
        }
    }

    public int getSize() {
        return this.dataSize;
    }

    public ColumnType getType() {
        return this.type;
    }

    public static ColumnValue fromLong(long value) {
        return new ColumnValue(value, ColumnType.INTEGER);
    }

    public static ColumnValue fromBoolean(boolean value) {
        return new ColumnValue(value, ColumnType.BOOLEAN);
    }

    public static ColumnValue fromDouble(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("DoubleNaNNotSupported"));
        }
        return new ColumnValue(value, ColumnType.DOUBLE);
    }

    public static ColumnValue fromBinary(byte[] value) {
        CodingUtils.assertParameterNotNull(value, "value");
        return new ColumnValue(value, ColumnType.BINARY);
    }

    public String asString() {
        if (this.type != ColumnType.STRING) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "STRING"));
        }
        return this.value.toString();
    }

    public static ColumnValue fromString(String value) {
        CodingUtils.assertParameterNotNull(value, "value");
        return new ColumnValue(value, ColumnType.STRING);
    }

    public long asLong() {
        if (this.type != ColumnType.INTEGER) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "INTEGER"));
        }
        return (Long)this.value;
    }

    public double asDouble() {
        if (this.type != ColumnType.DOUBLE) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "DOUBLE"));
        }
        Double result = (Double)this.value;
        if (result == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (result == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        return result;
    }

    public boolean asBoolean() {
        if (this.type != ColumnType.BOOLEAN) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BOOLEAN"));
        }
        return (Boolean)this.value;
    }

    public byte[] asBinary() {
        if (this.type != ColumnType.BINARY) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BINARY"));
        }
        return (byte[])this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColumnValue)) {
            return false;
        }
        ColumnValue val = (ColumnValue)o;
        if (this.type == val.type) {
            if (this.type == ColumnType.BINARY) {
                return Bytes.equals((byte[])this.value, (byte[])val.value);
            }
            return this.value.equals(val.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.type == ColumnType.BINARY) {
            return Arrays.hashCode(this.asBinary()) * 31 + this.type.hashCode();
        }
        return this.value.hashCode() * 31 + this.type.hashCode();
    }

    public String toString() {
        if (this.type == ColumnType.BINARY) {
            return Arrays.toString(this.asBinary()) + ":" + (Object)((Object)this.type);
        }
        return this.value.toString() + ":" + (Object)((Object)this.type);
    }

    @Override
    public int compareTo(ColumnValue target) {
        if (this.type != target.type) {
            throw new IllegalArgumentException("The type of column to compare must be the same.");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareTo(target.asString());
            }
            case INTEGER: {
                return ((Long)this.value).compareTo(target.asLong());
            }
            case BINARY: {
                byte[] b1 = (byte[])this.value;
                byte[] b2 = (byte[])target.value;
                int ret = Bytes.compareByteArrayInLexOrder(b1, 0, b1.length, b2, 0, b2.length);
                return ret;
            }
            case DOUBLE: {
                return ((Double)this.value).compareTo(target.asDouble());
            }
            case BOOLEAN: {
                return ((Boolean)this.value).compareTo(target.asBoolean());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
    }
}

