/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.OTSResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteRowResult
extends OTSResult {
    private Map<String, List<RowStatus>> tableToPutRowStatus = new HashMap<String, List<RowStatus>>();
    private Map<String, List<RowStatus>> tableToUpdateRowStatus = new HashMap<String, List<RowStatus>>();
    private Map<String, List<RowStatus>> tableToDeleteRowStatus = new HashMap<String, List<RowStatus>>();

    public BatchWriteRowResult(OTSResult meta) {
        super(meta);
    }

    public void addPutRowResult(RowStatus status) {
        this.addResult(status, this.tableToPutRowStatus);
    }

    public void addUpdateRowResult(RowStatus status) {
        this.addResult(status, this.tableToUpdateRowStatus);
    }

    public void addDeleteRowResult(RowStatus status) {
        this.addResult(status, this.tableToDeleteRowStatus);
    }

    private void addResult(RowStatus status, Map<String, List<RowStatus>> tableToRowStatus) {
        String tableName = status.getTableName();
        List<RowStatus> statuses = tableToRowStatus.get(tableName);
        if (statuses == null) {
            statuses = new ArrayList<RowStatus>();
            tableToRowStatus.put(tableName, statuses);
        }
        statuses.add(status);
    }

    public List<RowStatus> getPutRowStatus(String tableName) {
        return this.tableToPutRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getPutRowStatus() {
        return this.tableToPutRowStatus;
    }

    public List<RowStatus> getUpdateRowStatus(String tableName) {
        return this.tableToUpdateRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getUpdateRowStatus() {
        return this.tableToUpdateRowStatus;
    }

    public List<RowStatus> getDeleteRowStatus(String tableName) {
        return this.tableToDeleteRowStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getDeleteRowStatus() {
        return this.tableToDeleteRowStatus;
    }

    public List<RowStatus> getFailedRowsOfPut() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfPut(null, result);
        return result;
    }

    public List<RowStatus> getSucceedRowsOfPut() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfPut(result, null);
        return result;
    }

    public void getResultOfPut(List<RowStatus> succeedRows, List<RowStatus> failedRows) {
        for (Map.Entry<String, List<RowStatus>> entry : this.tableToPutRowStatus.entrySet()) {
            for (RowStatus rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public List<RowStatus> getFailedRowsOfUpdate() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfUpdate(null, result);
        return result;
    }

    public List<RowStatus> getSucceedRowsOfUpdate() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfUpdate(result, null);
        return result;
    }

    public void getResultOfUpdate(List<RowStatus> succeedRows, List<RowStatus> failedRows) {
        for (Map.Entry<String, List<RowStatus>> entry : this.tableToUpdateRowStatus.entrySet()) {
            for (RowStatus rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public List<RowStatus> getFailedRowsOfDelete() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfDelete(null, result);
        return result;
    }

    public List<RowStatus> getSucceedRowsOfDelete() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResultOfDelete(result, null);
        return result;
    }

    public void getResultOfDelete(List<RowStatus> succeedRows, List<RowStatus> failedRows) {
        for (Map.Entry<String, List<RowStatus>> entry : this.tableToDeleteRowStatus.entrySet()) {
            for (RowStatus rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public boolean isAllSucceed() {
        return this.getFailedRowsOfPut().isEmpty() && this.getFailedRowsOfUpdate().isEmpty() && this.getFailedRowsOfDelete().isEmpty();
    }

    public static class RowStatus {
        private boolean isSucceed = false;
        private Error error;
        private ConsumedCapacity consumedCapacity;
        private String tableName;
        private int index;

        public RowStatus(String tableName, ConsumedCapacity consumedCapacity, int index) {
            this.isSucceed = true;
            this.tableName = tableName;
            this.consumedCapacity = consumedCapacity;
            this.index = index;
        }

        public RowStatus(String tableName, Error error, int index) {
            this.isSucceed = false;
            this.tableName = tableName;
            this.error = error;
            this.index = index;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public Error getError() {
            return this.error;
        }

        public String getTableName() {
            return this.tableName;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

