/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.auth.RequestSigner;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.auth.ServiceSignature;
import com.aliyun.openservices.ots.comm.RequestMessage;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;

public class OTSRequestSigner
implements RequestSigner {
    private String otsAction;
    private ServiceCredentials credentials;

    public OTSRequestSigner(String otsAction, ServiceCredentials credentials) {
        CodingUtils.assertParameterNotNull(otsAction, "otsAction");
        CodingUtils.assertParameterNotNull(credentials, "credentials");
        this.otsAction = otsAction;
        this.credentials = credentials;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        try {
            String signature = OTSRequestSigner.getSignature(this.otsAction, request.getRequest().getMethod(), request.getQueryParameters(), request.getRequest().getAllHeaders(), this.credentials);
            request.addHeader("x-ots-signature", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("\u65e0\u6cd5\u8ba1\u7b97\u7b7e\u540d\uff1a" + e.getMessage());
        }
    }

    private static String getSignature(String action, String method, Map<String, String> queryParameters, Header[] headers, ServiceCredentials credentials) throws UnsupportedEncodingException {
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        Map<String, String> sortedMap = OTSRequestSigner.sortMap(headerMap);
        for (String key : sortedMap.keySet()) {
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key).append(":").append(sortedMap.get(key).trim()).append("\n");
        }
        if (queryParameters == null) {
            queryParameters = new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("/").append(action).append("\n").append(method).append("\n").append(queryParameters.size() == 0 ? "" : HttpUtil.paramToQueryString(OTSRequestSigner.sortMap(queryParameters), "utf-8")).append("\n").append(canonicalizedOtsHeader.toString());
        return ServiceSignature.create().computeSignature(credentials.getAccessKeySecret(), sb.toString());
    }

    private static Map<String, String> sortMap(Map<String, String> unsortMap) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(unsortMap);
        return sortedMap;
    }
}

