/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.comm.ResponseHandler;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OTSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(responseData, "responseData");
        if (responseData.isSuccessful()) {
            return;
        }
        Map<String, String> headers = responseData.getHeadersMap();
        int httpStatus = responseData.getStatusCode();
        if (httpStatus == 301) {
            if (!headers.containsKey("Location")) {
                throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "Location"), null);
            }
            String location = headers.get("Location");
            throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MovedPermanently", location));
        }
        InputStream errorStream = null;
        try {
            errorStream = responseData.getContent();
        }
        catch (IOException e) {
            throw new ClientException("Failed to read response from server.", e);
        }
        if (errorStream == null) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        if (!headers.containsKey("x-ots-requestid")) {
            throw new ClientException("InvalidResponse", "OTS returns a response with status code: " + responseData.getStatusCode() + ".", null);
        }
        try {
            OtsProtocol2.Error errMsg = OtsProtocol2.Error.parseFrom(errorStream);
            throw OTSExceptionFactory.create(errMsg, headers.get("x-ots-requestid"), httpStatus);
        }
        catch (IOException e) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
        }
    }
}

