/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.comm.OTSUri;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.BatchGetRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.BatchGetRowExecutionContext;
import com.aliyun.openservices.ots.internal.BatchWriteRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.BatchWriteRowExecutionContext;
import com.aliyun.openservices.ots.internal.DeleteRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.GetRangeAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.GetRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.PutRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.UpdateRowAsyncResponseConsumer;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.model.BatchGetRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowRequest;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.MultiRowQueryCriteria;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.google.protobuf.Message;
import java.util.Map;

public class OTSAsyncDataOperation
extends OTSOperation {
    private OTSUri URI_GET_ROW;
    private OTSUri URI_PUT_ROW;
    private OTSUri URI_UPDATE_ROW;
    private OTSUri URI_DELETE_ROW;
    private OTSUri URI_BATCH_GET_ROW;
    private OTSUri URI_BATCH_WRITE_ROW;
    private OTSUri URI_GET_RANGE;

    public OTSAsyncDataOperation(String endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(instanceName, client, credentials, serviceConfig);
        this.URI_GET_ROW = new OTSUri(endpoint, "GetRow");
        this.URI_PUT_ROW = new OTSUri(endpoint, "PutRow");
        this.URI_UPDATE_ROW = new OTSUri(endpoint, "UpdateRow");
        this.URI_DELETE_ROW = new OTSUri(endpoint, "DeleteRow");
        this.URI_BATCH_GET_ROW = new OTSUri(endpoint, "BatchGetRow");
        this.URI_BATCH_WRITE_ROW = new OTSUri(endpoint, "BatchWriteRow");
        this.URI_GET_RANGE = new OTSUri(endpoint, "GetRange");
    }

    public void getRow(OTSExecutionContext<GetRowRequest, GetRowResult> executionContext) {
        SingleRowQueryCriteria criteria = executionContext.getRequest().getRowQueryCriteria();
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_GET_ROW, null, (Message)OTSProtocolHelper.buildGetRowRequest(criteria), executionContext.getTraceLogger(), new GetRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.GetRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void putRow(OTSExecutionContext<PutRowRequest, PutRowResult> executionContext) {
        RowPutChange rowChange = executionContext.getRequest().getRowChange();
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_PUT_ROW, null, (Message)OTSProtocolHelper.buildPutRowRequest(rowChange), executionContext.getTraceLogger(), new PutRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.PutRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void updateRow(OTSExecutionContext<UpdateRowRequest, UpdateRowResult> executionContext) {
        RowUpdateChange rowChange = executionContext.getRequest().getRowChange();
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_UPDATE_ROW, null, (Message)OTSProtocolHelper.buildUpdateRowRequest(rowChange), executionContext.getTraceLogger(), new UpdateRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.UpdateRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void deleteRow(OTSExecutionContext<DeleteRowRequest, DeleteRowResult> executionContext) {
        RowDeleteChange rowChange = executionContext.getRequest().getRowChange();
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_DELETE_ROW, null, (Message)OTSProtocolHelper.buildDeleteRowRequest(rowChange), executionContext.getTraceLogger(), new DeleteRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DeleteRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void batchGetRow(BatchGetRowExecutionContext executionContext) {
        Map<String, MultiRowQueryCriteria> criteriasGroupByTable = ((BatchGetRowRequest)executionContext.getRequest()).getCriteriasByTable();
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_BATCH_GET_ROW, null, (Message)OTSProtocolHelper.buildBatchGetRowRequest(criteriasGroupByTable), executionContext.getTraceLogger(), new BatchGetRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.BatchGetRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext), executionContext.getAsyncClientCallback());
    }

    public void batchWriteRow(BatchWriteRowExecutionContext executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_BATCH_WRITE_ROW, null, (Message)OTSProtocolHelper.buildBatchWriteRowRequest((BatchWriteRowRequest)executionContext.getRequest()), executionContext.getTraceLogger(), new BatchWriteRowAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.BatchWriteRowResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext), executionContext.getAsyncClientCallback());
    }

    public void getRange(OTSExecutionContext<GetRangeRequest, GetRangeResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        RangeRowQueryCriteria criteria = executionContext.getRequest().getRangeRowQueryCriteria();
        this.asyncInvokePost(this.URI_GET_RANGE, null, (Message)OTSProtocolHelper.buildGetRangeRequest(criteria), executionContext.getTraceLogger(), new GetRangeAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.GetRangeResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }
}

