/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.PartialResultFailedException;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.OTSBasicFuture;
import java.util.concurrent.ScheduledExecutorService;

public class BatchWriteRowExecutionContext
extends OTSExecutionContext<BatchWriteRowRequest, BatchWriteRowResult> {
    private BatchWriteRowRequest originalRequest;
    private BatchWriteRowResult lastResult;

    public BatchWriteRowExecutionContext(BatchWriteRowRequest request, OTSBasicFuture future, OTSTraceLogger traceLogger, OTSRetryStrategy retryStrategy, ScheduledExecutorService retryExecutor) {
        super(request, future, traceLogger, retryStrategy, retryExecutor);
        this.originalRequest = request;
    }

    public BatchWriteRowResult getLastResult() {
        return this.lastResult;
    }

    @Override
    public void retry(Exception ex) {
        ++this.retries;
        if (ex instanceof PartialResultFailedException) {
            this.lastResult = (BatchWriteRowResult)((PartialResultFailedException)ex).getResult();
            BatchWriteRowRequest request = this.originalRequest.createRequestForRetry(this.lastResult.getFailedRowsOfPut(), this.lastResult.getFailedRowsOfUpdate(), this.lastResult.getFailedRowsOfDelete());
            this.setRequest(request);
        }
    }
}

