/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.comm;

import com.aliyun.openservices.ots.ClientConfiguration;
import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.comm.ExecutionContext;
import com.aliyun.openservices.ots.comm.RequestHandler;
import com.aliyun.openservices.ots.comm.RequestMessage;
import com.aliyun.openservices.ots.internal.OTSAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.ResourceManager;
import java.util.List;
import org.apache.http.concurrent.FutureCallback;

public abstract class ServiceClient {
    protected static ResourceManager rm = ResourceManager.getInstance("common");
    private ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.config;
    }

    public <Res> void asyncSendRequest(RequestMessage request, ExecutionContext context, OTSAsyncResponseConsumer<Res> consumer, FutureCallback<Res> callback, OTSTraceLogger traceLogger) {
        CodingUtils.assertParameterNotNull(request, "RequestMessage");
        CodingUtils.assertParameterNotNull(context, "ExecutionContext");
        context.getSigner().sign(request);
        this.handleRequest(request, context.getResquestHandlers());
        consumer.setContext(context);
        this.asyncSendRequestCore(request, context, consumer, callback, traceLogger);
    }

    protected abstract <Res> void asyncSendRequestCore(RequestMessage var1, ExecutionContext var2, OTSAsyncResponseConsumer<Res> var3, FutureCallback<Res> var4, OTSTraceLogger var5);

    protected void handleRequest(RequestMessage message, List<RequestHandler> resquestHandlers) throws ClientException {
        for (RequestHandler h : resquestHandlers) {
            h.handle(message);
        }
    }

    public abstract void shutdown();
}

