/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.connection;

import com.alibaba.rocketmq.common.MQVersion;
import com.alibaba.rocketmq.common.protocol.body.Connection;
import com.alibaba.rocketmq.common.protocol.body.ConsumerConnection;
import com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ConsumerConnectionSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "consumerConnection";
    }

    @Override
    public String commandDesc() {
        return "Query consumer's socket connection, client version and subscription";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("g", "consumerGroup", true, "consumer group name");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String group = commandLine.getOptionValue('g').trim();
            ConsumerConnection cc = defaultMQAdminExt.examineConsumerConnectionInfo(group);
            int i = 1;
            for (Connection conn : cc.getConnectionSet()) {
                System.out.printf("%03d  %-32s %-22s %-8s %s\n", i++, conn.getClientId(), conn.getClientAddr(), conn.getLanguage(), MQVersion.getVersionDesc((int)conn.getVersion()));
            }
            System.out.println("\nBelow is subscription:");
            Iterator it = cc.getSubscriptionTable().entrySet().iterator();
            i = 1;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                SubscriptionData sd = (SubscriptionData)entry.getValue();
                System.out.printf("%03d  Topic: %-40s SubExpression: %s\n", i++, sd.getTopic(), sd.getSubString());
            }
            System.out.println("");
            System.out.printf("ConsumeType: %s\n", cc.getConsumeType());
            System.out.printf("MessageModel: %s\n", cc.getMessageModel());
            System.out.printf("ConsumeFromWhere: %s\n", cc.getConsumeFromWhere());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

